% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgrate.R
\name{mgrate}
\alias{mgrate}
\title{Group Studies with Single Incidence Rates by Homogeneity}
\usage{
mgrate(data, event, time, studlab, ...)
}
\arguments{
\item{data}{A data frame containing the meta-analysis data.}

\item{event}{A vector of event counts.}

\item{time}{A vector of person-time at risk.}

\item{studlab}{A vector of study labels.}

\item{...}{Additional arguments passed on to `meta::metarate`.}
}
\value{
A list containing the final data with subgroup assignments (`data`),
the final `metarate` model (`model`), and the number of attempts (`attempts`).
}
\description{
This function iteratively assigns studies to subgroups based on a homogeneity
test. The goal is to create statistically homogeneous groups of studies
before performing a final meta-analysis of single incidence rates.
}
\details{
The algorithm starts with a single study in "group 1". It then processes
each subsequent study, attempting to place it in an existing group. A study
is added to a group only if its inclusion does not result in significant
within-group heterogeneity. If no suitable group is found, a new one is created.
}
\seealso{
\code{\link{meaning}}
}
\author{
Ahmed Abdelmageed \email{ahmedelsaeedmassad@gmail.com}
}
