% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALO.Algorithm.R
\name{ALO}
\alias{ALO}
\title{Optimization using Ant Lion Optimizer}
\usage{
ALO(FUN, optimType = "MIN", numVar, numPopulation = 40,
  maxIter = 500, rangeVar)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represent the type of optimization.
There are two option for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, which the function will do minimization.
Otherwise, you can use \code{"MAX"} for maximization problem.
The default value is \code{"MIN"}.}

\item{numVar}{a positive integer to determine the number variables.}

\item{numPopulation}{a positive integer to determine the number populations. The default value is 40.}

\item{maxIter}{a positive integer to determine the maximum number of iterations. The default value is 500.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables,
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively.
If all variable have equal upper bound, you can define \code{rangeVar} as
matrix (\eqn{2 \times 1}).}
}
\value{
\code{Vector [v1, v2, ..., vn]} where \code{n} is number variable
        and \code{vn} is value of \code{n-th} variable.
}
\description{
This is the internal function that implements Ant Lion Optimizer
Algorithm. It is used to solve continuous optimization tasks.
Users do not need to call it directly,
but just use \code{\link{metaOpt}}.
}
\details{
This algorithm was proposed by (Mirjalili, 2015). The Ant Lion Optimizer (ALO)
algorithm mimics the hunting mechanism of antlions in nature. Five main steps
of hunting prey such as the random walk of ants, building traps, entrapment of
ants in traps, catching preys, and re-building traps are implemented.

In order to find the optimal solution, the algorithm follow the following steps.
\itemize{
\item Initialization: Initialize the first population of ants and antlions randomly,
      calculate the fitness of ants and antlions and find the best antlions as the
      elite (determined optimum).
\item Update Ants Position: Select an antlion using Roulette Whell then update ants
      position based on random walk around selected antlion and elite.
      Furthermore, calculate the fitness of all ants.
\item Replace an antlion with its corresponding ant, if it becomes fitter
\item Update elite if an antlion becomes fitter than the elite
\item Check termination criteria, if termination criterion is satisfied, return the
      elite as the optimal solution for given problem. Otherwise, back to Update Ants Position steps.
}
}
\examples{
##################################
## Optimizing the schewefel's problem 2.22 function

# define schewefel's problem 2.22 function as objective function
schewefels2.22 <- function(x){
   return(sum(abs(x)+prod(abs(x))))
}

## Define parameter
numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## calculate the optimum solution using Ant Lion Optimizer
resultALO <- ALO(schewefels2.22, optimType="MIN", numVar, numPopulation=20,
                 maxIter=100, rangeVar)

## calculate the optimum value using schewefel's problem 2.22 function
optimum.value <- schewefels2.22(resultALO)

}
\references{
Seyedali Mirjalili, The Ant Lion Optimizer, Advances in Engineering Software,
Volume 83, 2015, Pages 80-98, ISSN 0965-9978,
https://doi.org/10.1016/j.advengsoft.2015.01.010
}
\seealso{
\code{\link{metaOpt}}
}
