#' Test datasets for microbiome age prediction.
#'
#' A list of three datasets to be used as test datasets
#' for microbiome age prediction using Random Forest model.
#'
#' @docType data
#'
#' @usage data(gtab.3stud)
#'
#' @format A list of three dataframes.
#'
#' @keywords test datasets
#'
#' @references Subramanian et al. Nature. 2014 Jun 19; 510(7505): 417–421.
#' (\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4189846/}{PubMed})
#'
#' Bender et al. Sci Transl Med. 2016 Jul 27; 8(349): 349ra100.
#' (\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC5301310/}{PubMed})
#'
#' Pannaraj et al. JAMA Pediatr. 2017;90095(7):647–54.
#' (\href{https://pubmed.ncbi.nlm.nih.gov/28492938/}{PubMed})
#'
#' Thompson et al. Front Cell Infect Microbiol. 2015;5:3.
#' (\href{https://pubmed.ncbi.nlm.nih.gov/25705611/}{PubMed})
#'
#' @source \href{https://gordonlab.wustl.edu/supplemental-data/supplemental-data-portal/subramanian-et-al-2014/}{Gordon Lab}
#'
#' @examples
#' data(gtab.3stud)
"gtab.3stud"
