% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{categorical_data_frame}
\alias{categorical_data_frame}
\title{Categorical Function for Data Frame}
\usage{
categorical_data_frame(
  x,
  yvar = NULL,
  xvar,
  groups = NULL,
  facets = NULL,
  ylab = metOption("xlab_categorical", "axislabel"),
  xlab = metOption("ylab_categorical", "axislabel"),
  na.rm = metOption("na.rm_categorical", TRUE),
  aspect = metOption("aspect_categorical", 1),
  space = metOption("space_categorical", "right"),
  key = metOption("key_categorical", "metaplot_key"),
  as.table = metOption("as.table_categorical", TRUE),
  prepanel = metOption("prepanel_categorical", function(...) list(xlim = 0:1, ylim =
    0:1)),
  scales = metOption("scales_categorical", NULL),
  panel = metOption("panel_categorical", "categorical_panel"),
  colors = metOption("colors_categorical", NULL),
  fill = metOption("fill_categorical", 0.5),
  lines = metOption("lines_categorical", TRUE),
  main = metOption("main_categorical", NULL),
  sub = metOption("sub_categorical", NULL),
  tex = metOption("tex_categorical", 0.9),
  rot = metOption("rot_categorical", c(90, 0)),
  subscripts = metOption("subscripts_categorical", TRUE),
  settings = metOption("settings_categorical", NULL),
  padding = metOption("padding_categorical", 1),
  loc = metOption("loc_categorical", 5),
  msg = metOption("msg_categorical", "tilestats"),
  cex = metOption("cex_categorical", 1),
  gg = metOption("gg_categorical", FALSE),
  verbose = metOption("verbose_categorical", FALSE),
  ...
)
}
\arguments{
\item{x}{data.frame}

\item{yvar}{character: y variable (optional)}

\item{xvar}{character: x variable}

\item{groups}{optional grouping variable (can be missing)}

\item{facets}{optional conditioning variables}

\item{ylab}{y axis label; can be function(x = x, var = yvar, ..)}

\item{xlab}{x axis label; can be function(x = x, var = xvar, ..)}

\item{na.rm}{whether to remove data points with one or more missing coordinates}

\item{aspect}{passed to \code{\link[lattice]{bwplot}} or ggplot; use 'fill', NA, or NULL to calculate automatically}

\item{space}{location of key (right, left, top, bottom)}

\item{key}{list: passed to \code{\link[lattice]{xyplot}} as \code{auto.key} or to \code{\link[ggplot2]{theme}}; can be a function groups name, groups levels, fill, lines, space, gg, type ('categorical'), and \dots .  See \code{\link{metaplot_key}}.}

\item{as.table}{passed to \code{\link[lattice]{xyplot}}}

\item{prepanel}{passed to \code{\link[lattice]{xyplot}} (guessed if NULL)}

\item{scales}{passed to \code{\link[lattice]{xyplot}} or \code{\link[ggplot2]{facet_grid}} or \code{\link[ggplot2]{facet_wrap}} (guessed if NULL)}

\item{panel}{name or definition of panel function for lattice}

\item{colors}{replacements for default colors in group order; can be length one integer to auto-select that many colors}

\item{fill}{whether to fill rectangles for each group: logical, or alpha values between 0 and 1}

\item{lines}{whether to plot borders for each group: logical, or alpha values between 0 and 1}

\item{main}{character, or a function of x, yvar, xvar, groups, facets}

\item{sub}{character, or a function of x, yvar, xvar, groups, facets}

\item{tex}{tile expansion: scale factor for reducing each tile size relative to full size (<= 1)}

\item{rot}{rotation for axis labels; can be length 2 for y and x axes, respectively}

\item{subscripts}{passed to \code{\link[lattice]{xyplot}}}

\item{settings}{default parameter settings: a list from which matching elements are passed to lattice (as par.settings) or  to ggplot theme()  and facet_wrap() or facet_grid().  \code{ncol} and \code{nrow} are used as layout indices for lattice (for homology with facet_wrap).}

\item{padding}{numeric (will be recycled to length 4) giving plot margins in default units: top, right, bottom, left (in multiples of 5.5 points for ggplot)}

\item{loc}{where to print statistics in a tile}

\item{msg}{a function of x and y to print text in a tile}

\item{cex}{expansion for msg text}

\item{gg}{logical: whether to generate \code{ggplot} instead of \code{trellis}}

\item{verbose}{generate messages describing process}

\item{...}{passed to \code{\link{region}}}
}
\description{
Categorical function for class 'data.frame'. Implements a simple mosaic plot.
}
\examples{

library(magrittr)
library(dplyr)
library(csv)
x <- as.csv(system.file(package = 'metaplot', 'extdata/theoph.csv'))
x \%<>\% pack
x \%>\% metaplot(site)
x \%>\% metaplot(site, gg = T)
x \%>\% metaplot(arm, site)
x \%>\% metaplot(arm, site, gg = T)
x \%>\% metaplot(arm, site, cohort)
x \%>\% metaplot(arm, site, cohort, gg = T)
x \%>\% metaplot(arm, site, cohort, space = 'top')
x \%>\% metaplot(arm, site, , cohort)
x \%>\% metaplot(arm, site, , cohort, gg = T)
\donttest{
x \%>\% metaplot(arm, site, , cohort, rot = c(0,90))
x \%>\% metaplot(arm, site, , cohort, rot = c(0,90), gg = T)
x \%>\% metaplot(arm, site, , cohort, rot = c(45, 45))
x \%>\% metaplot(subject,cohort,arm, site, lines = F, rot = c(45,45))
x \%>\% metaplot(subject,cohort,arm, site, lines = F, rot = c(45,45), gg=T)
# panel-specific axis not well-supported for gg version
x \%>\% metaplot(subject,cohort,,arm, site)
x \%>\% metaplot(subject,cohort,,arm, site, gg=T)
}
}
\seealso{
\code{\link{categorical_panel}}

Other categorical: 
\code{\link{categorical.data.frame}()},
\code{\link{categorical_panel}()},
\code{\link{categorical}()},
\code{\link{panel_tile}()}

Other metaplot: 
\code{\link{boxplot_data_frame}()},
\code{\link{corsplom_data_frame}()},
\code{\link{densplot_data_frame}()},
\code{\link{metaplot_key}()},
\code{\link{metaplot}()},
\code{\link{scatter_data_frame}()},
\code{\link{test_metaplot}()}
}
\concept{categorical}
\concept{metaplot}
