% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapro.R
\name{wZ}
\alias{wZ}
\title{wZ}
\usage{
wZ(p, weight = NULL, is.onetail = TRUE, eff.sign)
}
\arguments{
\item{p}{A numeric vector of p-values}

\item{weight}{A numeric vector of weights (e.g., sample sizes)}

\item{is.onetail}{Logical. If set TRUE, p-values are combined without considering the direction of effect, and vice versa. Default: TRUE.}

\item{eff.sign}{A vector of signs of effect sizes. It works when is.onetail = FALSE}
}
\value{
p : Combined p-value

overall.eff.direction : The direction of combined effects.

sumz : Sum of transformed z-score
}
\description{
P-value combination based on weighted Z-method
}
\examples{
wZ(p=c(0.01,0.2,0.8), weight = c(20,10,40), is.onetail=FALSE, eff.sign=c(1,-1,1))
}
\references{
Becker BJ (1994). “Combining significance levels.” In Cooper H, Hedges LV (eds.), A handbook of research synthesis, 215–230. Russell Sage, New York.

Stouffer SA, Suchman EA, DeVinney LC, Star SA, Williams RMJ (1949). The American soldier, vol 1: Adjustment during army life. Princeton University Press, Princeton.

Mosteller, F. & Bush, R.R. (1954). Selected quantitative techniques. In: Handbook of Social Psychology, Vol. 1 (G. Lindzey, ed.), pp. 289–334. Addison‐Wesley, Cambridge, Mass.
}
