% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaprotr_filter_text.R
\name{filter_text}
\alias{filter_text}
\title{filter_text}
\usage{
filter_text(spectral_count_object, pepsprots_feature, text_to_filter, decision)
}
\arguments{
\item{spectral_count_object}{List containing dataframes with proteomics
elements whose abundance is expressed as spectral counts and are
organized by peptides, subgroups, groups or taxonomic levels. 
The format of this object is similar to that generated from 
the functions "getsc_specific" and "crumble_taxonomy".}

\item{pepsprots_feature}{Character indicating the name of one explanatory 
variable (ONE column name) of the dataframe "peptides_proteins".}

\item{text_to_filter}{Character containig the text to be searched in 
the "pepsprots_feature" content.}

\item{decision}{Character indicating wether the elements containing 
the matched text will be kept or dirscarted. The two allowed option 
are: "keep" or "discard".}
}
\value{
A list defined as "spectral_count_object" with or without the 
    elements (peptides, subgroups, groups, taxonomic items) that 
    matched the provided text in a given variable of the 
    "peptides_proteins" dataframe.
}
\description{
Matches the entities containing a given chain of characters inside an explanatory 
variable (column name) of the dataframe "peptides_proteins" from a 
"spectral_count_object". Based on the user's decision, the peptides, subgroups, 
groups or taxonomic levels containig the provided chain of characters will 
be kept or discarted in a newly generated object.
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

data(fecal_waters)
data(species_fw)

cysteine_alkylations <- filter_text(fecal_waters, "Modifs", "57.02146", "keep")

exclude_medimonas <- filter_text(species_fw, "organism", "Merdimonas faecis BR31", "discard")

\dontshow{setwd(.old_wd)}
}
