% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmwp_ind.R
\name{bmwp_ind}
\alias{bmwp_ind}
\title{BMWP and ASPT index}
\usage{
bmwp_ind(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating if progress messages should be given.}
}
\value{
This function returns a list with the following components:
\item{Ibmwp_n}{The numerical BMWP and ASPT index (Armitage et al. 1983).}
\item{Ibmwp_c}{The BMWP and ASPT water quality class (Armitage et al. 1983).}
}
\description{
Calculate Biological Monitoring Working Party (BMWP) and Average Score Per Taxon (ASPT) indexes.
}
\details{
The Biological Monitoring Working Party (BMWP) was set up in 1976. Its terms of reference were to recommend a system which could be used to assess the biological status of a river, and which would be suitable for presenting a broad picture of one aspect of the biological condition of rivers in the UK. Identification to family is sufficient to calculate the BMWP score. The average score per taxon (ASPT) is calculated by dividing the score by the total number of scoring taxa (Armitage et al. 1983).
}
\examples{

#Load example data
example_data

#Run bmwp_ind with that example_data
bmwp<-bmwp_ind(example_data)

#Check results
bmwp$Ibmwp_n
bmwp$Ibmwp_c
}
\references{
Armitage PD, Moss D, Wright JF & Furse MT (1983). The performance of a new biological water quality score system based on macroinvertebrates over a wide range of unpolluted running-water sites. \doi{10.1016/0043-1354(83)90188-4}
}
\seealso{
\link[metrix]{read_data}, \link{bmwp_p_ind}, \link{bmwp_p_p_ind}, \link{biotic_ind}
}
\author{
Juan Manuel Cabrera and Julieta Capeletti.
}
