% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmwp_p_ind.R
\name{bmwp_p_ind}
\alias{bmwp_p_ind}
\title{BMWP prime index}
\usage{
bmwp_p_ind(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating if progress messages should be given.}
}
\value{
This function returns a list with the following components:
\item{Ibmwp_p_n}{The numerical BMWP’ index (Alba Tercedor and Sánchez Ortega 1988).}
\item{Ibmwp_p_c}{The BMWP’ index water quality classes (Alba Tercedor and Sánchez Ortega 1988).}
}
\description{
Calculate Biological Monitoring Working Party (BMWP) prime index.
}
\details{
The BMWP’ is an adaptation of the BMWP (Armitage et al. 1983) created to evaluate the biological quality of the Iberian Peninsula. Most of the macroinvertebrate families living in the Iberian Peninsula have been added to the original index and some of the scores have been changed (Alba Tercedor & Sánchez Ortega 1988).
}
\examples{

#Load example data
example_data

#Run bmwp_p_ind with that example_data
bmwpp<-bmwp_p_ind(example_data)

#Check results
bmwpp$Ibmwp_p_n
bmwpp$Ibmwp_p_c
}
\references{
Armitage PD, Moss D, Wright JF & Furse MT (1983). The performance of a new biological water quality score system based on macroinvertebrates over a wide range of unpolluted running-water sites. \doi{10.1016/0043-1354(83)90188-4}

Alba-Tercedor J & Sánchez-Ortega A (1988). A simple and quick method to evaluate biological quality of running freshwater based on Hellawell (1978). \url{https://www.limnetica.com/documentos/limnetica/limnetica-4-1-p-51.pdf}
}
\seealso{
\link[metrix]{read_data}, \link{bmwp_ind}, \link{bmwp_p_p_ind}, \link{biotic_ind}
}
\author{
Juan Manuel Cabrera and Julieta Capeletti.
}
