% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_lines.R
\name{fun_lines}
\alias{fun_lines}
\title{weighted sum/difference of two regression vectors}
\usage{
fun_lines(i, j, beta, fun = `-`, ni = 1, nj = 1)
}
\arguments{
\item{i}{integer scalar. Index of the first vector.}

\item{j}{integer scalar. Index of the second vector.}

\item{beta}{p by p numeric matrix. In rows, regression vectors coefficients after node-wise regression. \code{diag(beta) = 0}.}

\item{fun}{function. Applied on lines.}

\item{ni}{integer scalar. Weight for vector \code{i}.}

\item{nj}{integer scalar. Weight for vector \code{j}.}
}
\value{
numeric vector
}
\description{
\code{fun_lines} applies function \code{fun} to regression vectors while reordering the coefficients,
such that the \code{j}-th coefficient in \code{beta[j, ]} is permuted with the \code{i}-th coefficient.
}
\examples{
beta <- matrix(round(rnorm(9),2), ncol = 3)
diag(beta) <- 0
beta
fun_lines(1, 2, beta)
fun_lines(2, 1, beta)
}
