% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgsub_censor.R
\name{mgsub_censor}
\alias{mgsub_censor}
\title{Safe, multiple censoring of text strings}
\usage{
mgsub_censor(string, pattern, censor = "*", split = any(nchar(censor) >
  1), seed = NULL, ...)
}
\arguments{
\item{string}{a character vector to censor}

\item{pattern}{regular expressions used to identify where to censor}

\item{censor}{character to use in censoring - see details}

\item{split}{if a multicharacter censor pattern is provided, should it be
split to preserve original string length}

\item{seed}{optional parameter to fix sampling of multicharacter censors}

\item{\dots}{arguments to pass to \code{\link[base:grep]{regexpr}} /
\code{\link[base:grep]{sub}}}
}
\value{
Censored string.
}
\description{
\code{mgsub_censor} - A safe, simultaneous, multiple global string censoring
 (replace matches with a censoring character like '*')
}
\details{
When censor is provided as a >1 length vector or as a multicharacter
string with split = TRUE, it will be sampled to return random censoring patterns.
This can be helpful if you want to create cartoonish swear censoring. If
needed, the randomization can be controlled with the seed argument.
}
\examples{
mgsub_censor("Flowers for a friend", pattern=c("low"), censor="*")
}
