% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotVarConvergence.R
\name{plotVarConvergence}
\alias{plotVarConvergence}
\title{plotVarConvergence}
\usage{
plotVarConvergence(miceObj, vars = names(miceObj$callParams$vars), ...)
}
\arguments{
\item{miceObj}{an object of class \code{miceDefs}, created by the \code{miceRanger} function.}

\item{vars}{the variables you want to plot. Default is to plot all variables. Can be a vector of
variable names, or one of 'allNumeric' or 'allCategorical'}

\item{...}{options passed to \code{ggarrange()}}
}
\value{
an object of class \code{ggarrange}.
}
\description{
Plot the evolution of the dispersion and center of each variable.
For numeric variables, the center is the mean, and the dispersion is the standard deviation.
For categorical variables, the center is the mode, and the dispersion is the entropy of the distribution.
}
\examples{
data("sampleMiceDefs")
plotVarConvergence(sampleMiceDefs)
}
