% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_experiment_list.R
\name{generate_experiment_list}
\alias{generate_experiment_list}
\alias{ask_experiment_list}
\title{Generate list of experiment names from user parameters}
\usage{
generate_experiment_list(experiment_names, file_list)

ask_experiment_list(file_list)
}
\arguments{
\item{experiment_names}{A character vector containing names for each experiment.}

\item{file_list}{A character vector of file IDs. Used to extract experiment IDs from.}
}
\value{
\code{generate_experiment_list} returns a list of experiment names where each level is assigned to a corresponding 
        row or column based on the selected direction parameter.

\code{ask_experiment_list} returns a list containing experiment identifiers as keys and experiment names as values.
}
\description{
\code{generate_experiment_list} generates a list of provided experiment names extracted
from file names.

\code{ask_experiment_list} works the same way as \code{generate_experiment_list}, but retrieves the
experiment names based on a user prompt instead of user-set parameters.
}
\details{
\code{generate_experiment_list} extracts unique identifiers from file names and matches them with the 
provided experiment names. If the number of experiment names does not match the number 
of unique identifiers extracted from the file names, it throws an error. If the lengths match,
it generates a list of experiment names where each name is associated with a unique
identifier extracted from the file names.
}
\seealso{
\code{\link{generate_group_list}}, \code{\link{ask_group_list}},
\code{\link{add_treatment}}, \code{\link{add_concentration}}
}
