% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cip}
\alias{cip}
\title{Table of academic programs}
\format{
\code{data.table} with 1582 rows and 6 columns keyed by the 6-digit CIP
code:

\describe{

\item{\code{cip6}}{Character 6-digit code representing "specific
instructional programs" (US National Center for Education Statistics).}

\item{\code{cip6name}}{Character program name at the 6-digit level}

\item{\code{cip4}}{Character 4-digit code (the first 4 digits of \code{cip6})
representing "intermediate groupings of programs that have
comparable content and objectives."}

\item{\code{cip4name}}{Character program name at the 4-digit level.}

\item{\code{cip2}}{Character 2-digit code (the first 2 digits of \code{cip6})
representing "the most general groupings of related programs."}

\item{\code{cip2name}}{Character program name at the 2-digit level.}

}
}
\usage{
cip
}
\description{
A data table based on the US National Center for Education Statistics (NCES),
Integrated Postsecondary Education Data System (IPEDS), 2010 CIP,
\url{http://nces.ed.gov/ipeds/cipcode/}. The data are codes and names for
1582 instructional programs organized on three levels: a 2-digit series, a
4-digit series, and a 6-digit series.
}
\details{
The midfielddata taxonomy includes one non-IPEDS code (999999) for Undecided
or Unspecified, instances in which institutions reported no program
information or that students were not enrolled in a program.

The MIDFIELD research database include CIPs for undergraduate pre-majors
such as pre-med (511102), pre-law (220001), and pre-vet (511104).
}
\seealso{
Other cip-data: 
\code{\link{fye_proxy}}
}
\concept{cip-data}
\keyword{datasets}
