% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkcra.R
\name{checkCRA}
\alias{checkCRA}
\title{Inspect complete records analysis model}
\usage{
checkCRA(y, covs, r_cra, mdag)
}
\arguments{
\item{y}{The analysis model outcome, specified as a string}

\item{covs}{The analysis model covariate(s), specified as a string (space
delimited)}

\item{r_cra}{The complete record indicator, specified as a string}

\item{mdag}{The DAG, specified as a string using \link[dagitty]{dagitty}
syntax}
}
\value{
A message indicating whether complete records analysis is valid under
the proposed DAG and analysis model outcome and covariate(s)
}
\description{
Check complete records analysis is valid under the proposed analysis model
and directed acyclic graph (DAG). Validity means that the proposed approach
will allow unbiased estimation of the estimand(s) of interest, including
regression parameters, associations, and causal effects.
}
\details{
The DAG should include all observed and unobserved variables related to the
analysis model variables and their missingness, as well as all required
missingness indicators.

In general, complete records analysis is valid if the analysis model outcome
and complete record indicator are unrelated, conditional on the specified
covariates. This is determined using the proposed DAG by checking whether the
analysis model and complete record indicator are 'd-separated', given the
covariates.
}
\examples{
# Example DAG for which complete records analysis is not valid, but could be
## valid for a different set of covariates
checkCRA(y="bmi7", covs="matage", r_cra="r",
         mdag="matage -> bmi7 mated -> matage mated -> bmi7
               sep_unmeas -> mated sep_unmeas -> r")
# For the DAG in the example above, complete records analysis is valid
## if a different set of covariates is used
checkCRA(y="bmi7", covs="matage mated", r_cra="r",
         mdag="matage -> bmi7 mated -> matage mated -> bmi7
               sep_unmeas -> mated sep_unmeas -> r")

# Example DAG for which complete records is not valid, but could be valid
## for a different estimand
checkCRA(y="bmi7", covs="matage mated", r_cra="r",
         mdag="matage -> bmi7 mated -> matage mated -> bmi7
               sep_unmeas -> mated sep_unmeas -> r matage -> bmi3
               mated -> bmi3 bmi3 -> bmi7 bmi3 -> r")

# Example DAG for which complete records analysis is never valid
checkCRA(y="bmi7", covs="matage mated", r_cra="r",
         mdag="matage -> bmi7 mated -> matage mated -> bmi7
               sep_unmeas -> mated sep_unmeas -> r bmi7 -> r")
}
\references{
Hughes R, Heron J, Sterne J, Tilling K. 2019. Accounting for
missing data in statistical analyses: multiple imputation is not always the
answer. Int J Epidemiol. \url{doi:10.1093/ije/dyz032}

Bartlett JW, Harel O, Carpenter JR. 2015. Asymptotically Unbiased
Estimation of Exposure Odds Ratios in Complete Records Logistic Regression.
Am J Epidemiol. \url{doi:10.1093/aje/kwv114}
}
