% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tnorm_kdens_arma}
\alias{tnorm_kdens_arma}
\title{Truncated Gaussian kernel density estimator}
\usage{
tnorm_kdens_arma(x, newdata, Omega, beta, logd)
}
\arguments{
\item{x}{\code{n} by \code{d} matrix of quantiles}

\item{newdata}{matrix of new observations at which to evaluated the kernel density}

\item{Omega}{\code{d} by \code{d} positive definite scale matrix \eqn{\boldsymbol{\Omega}}}

\item{beta}{\code{d} vector \eqn{\boldsymbol{\beta}} defining the half-space through \eqn{\boldsymbol{\beta}^{\top}\boldsymbol{\xi}>0}}
}
\value{
the value of the likelihood cross-validation criterion
}
\description{
Given a data matrix over a half-space defined by \code{beta},
compute the log density of the asymmetric truncated Gaussian kernel density estimator,
taking in turn an observation as location vector.
}
\keyword{internal}
