% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processforanova.R
\name{processforanova}
\alias{processforanova}
\title{Processes cluster signaling data in form for statistical analysis}
\usage{
processforanova(filtereddata)
}
\arguments{
\item{filtereddata}{a list with each element corresonding to a cluster of interest and matrices containing individual sample data for desired markers}
}
\value{
A dataframe sufficient for using the posthoc function to compute statistics
}
\description{
Processes cluster signaling data in form for statistical analysis
}
\examples{
library(mineCitrus)
data("citrus.combinedFCSSet")
data("citrus.foldClustering")
data("citrus.foldFeatureSet")
meds<-allmeds(citrus.combinedFCSSet=citrus.combinedFCSSet,
              citrus.foldClustering=citrus.foldClustering,
              citrus.foldFeatureSet=citrus.foldFeatureSet)
filteredmeds<-findclust(data=meds,clusters=c(19999,19972,19988))
foranova<-processforanova(filtereddata=filteredmeds)
}
