% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.item.R
\name{extract.item}
\alias{extract.item}
\title{Extract an item object from \code{mirt} objects}
\usage{
extract.item(x, item, group = NULL, drop.zeros = FALSE)
}
\arguments{
\item{x}{mirt model of class \code{'SingleGroupClass'}, \code{'MultipleGroupClass'}, or
\code{'MixtureClass'}}

\item{item}{a number or character signifying which item to extract}

\item{group}{a number signifying which group the item should be extracted from (applies to
\code{'MultipleGroupClass'} and \code{'MixtureClass'} only)}

\item{drop.zeros}{logical; drop slope values that are numerically close to zero to reduce
dimensionality? Useful in objects returned from \code{\link{bfactor}} or other confirmatory
models that contain several zero slopes}
}
\description{
Extract the internal \code{mirt} objects from any estimated model.
}
\examples{

\donttest{
mod <- mirt(Science, 1)
extr.1 <- extract.item(mod, 1)
}
}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\seealso{
\code{\link{extract.group}}, \code{\link{extract.mirt}}
}
\keyword{extract}
