% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/misclassGLM.R
\name{misclassGLM}
\alias{misclassGLM}
\title{GLM estimation under misclassified covariate}
\usage{
misclassGLM(
  Y,
  X,
  setM,
  P,
  na.action = na.omit,
  family = gaussian(link = "identity"),
  control = list(),
  par = NULL,
  x = FALSE,
  robust = FALSE
)

misclassGLM(
  Y,
  X,
  setM,
  P,
  na.action = na.omit,
  family = gaussian(link = "identity"),
  control = list(),
  par = NULL,
  x = FALSE,
  robust = FALSE
)
}
\arguments{
\item{Y}{a vector of integers or numerics. This is the dependent variable.}

\item{X}{a matrix containing the independent variables.}

\item{setM}{(optional) matrix, rows containing potential patterns for a misclassified (latent) covariate M
in any coding for a categorical independent variable, e.g. dummy coding (default: Identity).}

\item{P}{probabilities corresponding to each of the potential pattern conditional on the other
covariates denoted in x.}

\item{na.action}{how to treat NAs}

\item{family}{a description of the error distribution and link function to be used in the model.
This can be a character string naming a family function, a family function or the result
of a call to a family function. (See \code{\link{family}} for details of family functions.)}

\item{control}{options for the optimization procedure (see \code{\link{optim}},
\code{\link[ucminf]{ucminf}} for options and details).}

\item{par}{(optional) starting parameter vector}

\item{x}{logical, add covariates matrix to result?}

\item{robust}{logical, if true the computed asymptotic standard errors are replaced by their
robust counterparts.}
}
\description{
\code{misclassGLM} computes estimator for a GLM with a misclassified covariate
using additional side information on the misclassification process

\code{misclassGLM} computes estimator for a GLM with a misclassified covariate
using additional side information on the misclassification process
}
\examples{
## simulate data
\donttest{
data <- simulate_GLM_dataset()
}

## estimate model without misclassification error
\donttest{
summary(lm(Y ~ X + M2, data))
}

## estimate model with misclassification error
\donttest{
summary(lm(Y ~ X + M, data))
}

## estimate misclassification probabilities
\donttest{
Pmodel <- glm(M2 ~ M + X, data = data, family = binomial("logit"))
summary(Pmodel)
}

## construct a-posteriori probabilities from Pmodel
\donttest{
P <- predict(Pmodel, newdata = data, type = "response")
P <- cbind(1 - P, P)
dimnames(P)[[2]] <- c("M0", "M1") ## speaking names
}

## estimate misclassGLM
\donttest{
est <- misclassGLM(Y = data$Y,
                   X = as.matrix(data[, 2, drop = FALSE]),
                   setM = matrix(c(0, 1), nrow = 2),
                   P = P)
summary(est)
}

## and bootstrapping the results from dataset
\dontrun{
  summary(boot.misclassGLM(est,
                           Y = data$Y,
                           X = data.matrix(data[, 2, drop = FALSE]),
                           Pmodel = Pmodel,
                           PX = data,
                           repetitions = 100))
}

## simulate data
\donttest{
data <- simulate_GLM_dataset()
}

## estimate model without misclassification error
\donttest{
summary(lm(Y ~ X + M2, data))
}

## estimate model with misclassification error
\donttest{
summary(lm(Y ~ X + M, data))
}

## estimate misclassification probabilities
\donttest{
Pmodel <- glm(M2 ~ M + X, data = data, family = binomial("logit"))
summary(Pmodel)
}

## construct a-posteriori probabilities from Pmodel
\donttest{
P <- predict(Pmodel, newdata = data, type = "response")
P <- cbind(1 - P, P)
dimnames(P)[[2]] <- c("M0", "M1") ## speaking names
}

## estimate misclassGLM
\donttest{
est <- misclassGLM(Y = data$Y,
                   X = as.matrix(data[, 2, drop = FALSE]),
                   setM = matrix(c(0, 1), nrow = 2),
                   P = P)
summary(est)
}

## and bootstrapping the results from dataset
\dontrun{
  summary(boot.misclassGLM(est,
                           Y = data$Y,
                           X = data.matrix(data[, 2, drop = FALSE]),
                           Pmodel = Pmodel,
                           PX = data,
                           repetitions = 100))
}

}
