% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals-iterator.R
\name{giterator.intervals}
\alias{giterator.intervals}
\title{Returns iterator intervals}
\usage{
giterator.intervals(
  expr = NULL,
  intervals = .misha$ALLGENOME,
  iterator = NULL,
  band = NULL,
  intervals.set.out = NULL,
  interval_relative = FALSE,
  partial_bins = c("clip", "exact", "drop")
)
}
\arguments{
\item{expr}{track expression}

\item{intervals}{genomic scope}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expression.}

\item{band}{track expression band. If 'NULL' no band is used.}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}

\item{interval_relative}{if TRUE, and iterator is numeric, bins start at each interval's start
position instead of chromosome position 0. Returns intervalID column. Default: FALSE.}

\item{partial_bins}{how to handle partial bins at interval boundaries when
interval_relative is TRUE. One of "clip" (default, truncate last bin to
interval boundary), "exact" or "drop" (only output full-size bins).}
}
\value{
If 'intervals.set.out' is 'NULL' a data frame representing iterator intervals.
When 'interval_relative' is TRUE, includes an 'intervalID' column.
}
\description{
Returns iterator intervals given track expression, scope, iterator and band.
}
\details{
This function returns a set of intervals used by the iterator intervals for
the given track expression, genomic scope, iterator and band. Some functions
accept an iterator without accepting a track expression (like
'gtrack.create_pwm_energy'). These functions generate the values for each
iterator interval by themselves. Use set 'expr' to 'NULL' to simulate the
work of these functions.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Use this parameter if the result size exceeds the limits of the
physical memory.

When 'interval_relative' is TRUE, bins are aligned to each input interval's
start position rather than chromosome position 0. This mode requires a
numeric iterator (binsize) and returns an additional 'intervalID' column
indicating which input interval spawned each bin.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

## iterator is set implicitly to bin size of 'dense' track
giterator.intervals("dense_track", gintervals(1, 0, 200))

## iterator = 30
giterator.intervals("dense_track", gintervals(1, 0, 200), 30)

## iterator is an intervals set named 'annotations'
giterator.intervals("dense_track", .misha$ALLGENOME, "annotations")

## iterator is set implicitly to intervals of 'array_track' track
giterator.intervals("array_track", gintervals(1, 0, 200))

## iterator is a rectangle 100000 by 50000
giterator.intervals(
    "rects_track",
    gintervals.2d(chroms1 = 1, chroms2 = "chrX"),
    c(100000, 50000)
)

## interval_relative mode: bins aligned to each interval's start
intervs <- gintervals(1, c(100, 500), c(300, 700))
giterator.intervals(NULL, intervs, iterator = 50, interval_relative = TRUE)

}
\seealso{
\code{\link{giterator.cartesian_grid}}
}
\keyword{~intervals}
\keyword{~iterator}
