% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-attr.R
\name{gtrack.attr.set}
\alias{gtrack.attr.set}
\title{Assigns value to a track attribute}
\usage{
gtrack.attr.set(track = NULL, attr = NULL, value = NULL)
}
\arguments{
\item{track}{track name}

\item{attr}{attribute name}

\item{value}{value}
}
\value{
None.
}
\description{
Assigns value to a track attribute.
}
\details{
This function creates a track attribute and assigns 'value' to it. If the
attribute already exists its value is overwritten.

If 'value' is an empty string the attribute is removed.

Error is reported on an attempt to modify a value of a read-only attribute.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
gtrack.attr.set("sparse_track", "test_attr", "value")
gtrack.attr.get("sparse_track", "test_attr")
gtrack.attr.set("sparse_track", "test_attr", "")

}
\seealso{
\code{\link{gtrack.attr.get}}, \code{\link{gtrack.attr.import}},
\code{\link{gtrack.var.set}}, \code{\link{gdb.get_readonly_attrs}}
}
\keyword{~attr}
\keyword{~attribute}
