% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_imputation_error.R
\name{evaluate_imputation_error}
\alias{evaluate_imputation_error}
\title{Evaluate the imputation error when true values are known.}
\usage{
evaluate_imputation_error(ximp, xmis, xtrue, all = FALSE)
}
\arguments{
\item{ximp}{imputed dataframe.}

\item{xmis}{original dataframe with missing values.}

\item{xtrue}{true dataframe with no missing values.}

\item{all}{calculate error on all observations (TRUE) or only on missing observations (FALSE). Default is FALSE.}
}
\value{
Dataframe with variables in rows and performance measures in columns.
}
\description{
Evaluate the imputation error when true values are known. Useful when missing values are simulated
and true values are known (the errors are calculated as distances from the true values).
For continuous variables, MSE (mean square error) and NMSE (normalized mean square error) are returned.
For categorical variables, MER (misclassification error rate) is returned.
}
\details{
For details check the advanced vignette on convergence criteria and error monitoring.
}
