% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_LS_combined.R
\name{impute_LS_combined}
\alias{impute_LS_combined}
\title{LSimpute_combined}
\usage{
impute_LS_combined(
  ds,
  k = 10,
  eps = 1e-06,
  min_common_obs = 5,
  p_mis_sim = 0.05,
  verbose_gene = FALSE,
  verbose_array = FALSE,
  verbose_gene_p = FALSE,
  verbose_array_p = FALSE
)
}
\arguments{
\item{ds}{A data frame or matrix with missing values.}

\item{k}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{eps}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{min_common_obs}{Directly passed to \code{\link[=impute_LS_gene]{impute_LS_gene()}}.}

\item{p_mis_sim}{Percentage of observed values that are set \code{NA} to estimate
the mixing coefficient \emph{p}. The default value (0.05) corresponds to the
choice of Bo et al. (2004).}

\item{verbose_gene}{Should \code{impute_LS_gene()} be \code{verbose}?}

\item{verbose_array}{Should \code{impute_LS_array()} be \code{verbose}?}

\item{verbose_gene_p}{Should \code{impute_LS_gene()} be \code{verbose} while estimating
\emph{p}?}

\item{verbose_array_p}{Should \code{impute_LS_array()} be \code{verbose} while
estimating \emph{p}?}
}
\value{
An object of the same class as \code{ds} with imputed missing values.
}
\description{
Perform LSimpute_combined as described by Bo et al. (2004)
}
\details{
This function performs LSimpute_combined as described by Bo et al. (2004).The function assumes that the genes are the rows of \code{ds}.

LSimpute_combined combines imputation values from \code{\link[=impute_LS_gene]{impute_LS_gene()}} and
\code{\link[=impute_LS_array]{impute_LS_array()}} using a global approach for the mixing coefficient \emph{p}.
The amount of feedback given from these underlying functions is controlled
via \verb{verbose_gene, verbose_array, verbose_gene_p, verbose_array_p}. The last
two control the amount of feedback while estimating \emph{p} and the first two
the amount of feedback during the estimation of the values that are mixed
with \emph{p}. Internally,  the imputed dataset from \code{impute_LS_gene()} is passed
on to \code{impute_LS_array()}. Therefore, all messages from \code{impute_LS_gene()}
are truly from \code{impute_LS_gene()} and not a part of \code{impute_LS_array()},
which never calls \code{impute_LS_gene()} in this case. Furthermore, all messages
from \code{\link[=impute_expected_values]{impute_expected_values()}} belong to \code{impute_LS_array()}.
}
\examples{
set.seed(123)
ds_mis <- delete_MCAR(mvtnorm::rmvnorm(100, rep(0, 10)), 0.1)
ds_imp <- impute_LS_combined(ds_mis)
}
\references{
Bo, T. H., Dysvik, B., & Jonassen, I. (2004). LSimpute: accurate estimation of missing values in microarray data with least squares methods. Nucleic acids research, 32(3), e34
}
\seealso{
Other LSimpute functions: 
\code{\link{impute_LS_adaptive}()},
\code{\link{impute_LS_array}()},
\code{\link{impute_LS_gene}()}
}
\concept{LSimpute functions}
