% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missSBM-package.R
\docType{package}
\name{missSBM-package}
\alias{missSBM}
\alias{missSBM-package}
\title{missSBM: Handling Missing Data in Stochastic Block Models}
\description{
When a network is partially observed (here, NAs in the adjacency matrix rather than 1 or 0 due to missing information between node pairs), it is possible to account for the underlying process that generates those NAs. 'missSBM', presented in 'Barbillon, Chiquet and Tabouy' (2022) \doi{10.18637/jss.v101.i12}, adjusts the popular stochastic block model from network data sampled under various missing data conditions, as described in 'Tabouy, Barbillon and Chiquet' (2019) \doi{10.1080/01621459.2018.1562934}.

The missSBM package provides the following top-level functions functions:
}
\details{
\itemize{
\item \code{\link{observeNetwork}} a function to draw a partially observe network from an existing, fully observed network according to a variety of sampling designs
\item \code{\link{estimateMissSBM}} a function to perform inference of SBM from a partially observed under various sampling designs.
}

These function leads to the manipulation of a variety of R objects instantiated from some R6 classes, with their respective fields and methods.
They are all generated by the top-level functions itemized above, so that the user should generally not use their constructor or internal methods
directly. The user should only have a basic understanding of the fields of each object to manipulate the output in R. The main objects are the following:
\itemize{
\item \code{\link{missSBM_fit}} an object that put together an SBM fit and and network sampling fit - the main point of the missSBM package !
\item \code{\link{missSBM_collection}} an object to store a collection of missSBM_fit, ordered by number of block
\item \code{\link{SimpleSBM_fit_MNAR}} an object to define and store an SBM fit with MNAR values
\item \code{\link{SimpleSBM_fit_noCov}} an object to define and store an SBM fit without covariate, MAR values
\item \code{\link{SimpleSBM_fit_withCov}} an object to define and store an SBM fit with covariates, MAR values
\item \code{\link{networkSampling}} an object to define and store a network sampling fit
}

missSBM extends some functionality of the package sbm, by inheriting from classes and methods associated to simple stochastic block models.
}
\references{
\itemize{
\item Pierre Barbillon, Julien Chiquet & Timothée Tabouy (2022) "missSBM: An R Package for Handling Missing Values in the Stochastic Block Model", Journal of Statistical Software, \doi{10.18637/jss.v101.i12}
\item Timothée Tabouy, Pierre Barbillon & Julien Chiquet (2019) “Variational Inference for Stochastic Block Models from Sampled Data”, Journal of the American Statistical Association, \doi{10.1080/01621459.2018.1562934}
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://grosssbm.github.io/missSBM/}
  \item Report bugs at \url{https://github.com/grossSBM/missSBM/issues}
}

}
\author{
\strong{Maintainer}: Julien Chiquet \email{julien.chiquet@inrae.fr} (\href{https://orcid.org/0000-0002-3629-3429}{ORCID})

Authors:
\itemize{
  \item Pierre Barbillon \email{pierre.barbillon@agroparistech.fr} (\href{https://orcid.org/0000-0002-7766-7693}{ORCID})
  \item Timothée Tabouy \email{timothee.tabouy@agroparistech.fr}
}

Other contributors:
\itemize{
  \item Jean-Benoist Léger \email{jbleger@hds.utc.fr} (provided C++ implementaion of K-means) [contributor]
  \item François Gindraud \email{francois.gindraud@gmail.com} (provided C++ interface to NLopt) [contributor]
  \item großBM team [contributor]
}


Pierre Barbillon \email{pierre.barbillon@agroparistech.fr}

Julien Chiquet \email{julien.chiquet@inrae.fr}

Timothée Tabouy \email{timothee.tabouy@gmail.com}
}
\keyword{internal}
