% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixcure.r
\name{residuals.mixcure}
\alias{residuals.mixcure}
\title{Residuals for mixture cure models}
\usage{
\method{residuals}{mixcure}(
  object,
  data,
  type = c("WLCH", "Cox-Snell", "M-Cox-Snell", "Martingale", "M-Martingale", "M2",
    "M3", "D2"),
  type2 = c("residuals", "partial"),
  model = c("latency", "incidence"),
  ...
)
}
\arguments{
\item{object}{an object of mixcure}

\item{data}{the data used to obtain mixcure object.}

\item{type}{residuals type. WLCH is a modified residual proposed in Wileyto
et al (2013). The rest types of residuals are defined in the same way as in
the classic survival models.}

\item{type2}{residual type, either "residuals" for regular residuals or
"partial" for partial residuals),}

\item{model}{if "latency" (default), residuals for latency model are generated.
Otherwise, "incidence" means that residuals for incidence model are generated.}

\item{...}{for compatibility purpose. Not used.}
}
\value{
It is a list containing at least the following components:
  \item{type}{residuals type}
  \item{residuals}{residuals of the model}
}
\description{
Obtain residuals for the mixture cure models
}
\details{
This function computes residuals for the fitted model from mixcure().
}
\examples{

data(leukaemia)
residuals(mixcure(Surv(time, cens) ~ transplant, ~ transplant,
data = leukaemia), data = leukaemia, type = "Martingale")


}
\references{
Peng, Y. and Taylor, J. M. G. Residual-based model diagnosis methods for
mixture cure models.  Biometrics, 73:495–505, 2017
}
\seealso{
mixcure
}
\author{
Yingwei Peng
}
