% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KendallCCA.R
\name{standardCCA}
\alias{standardCCA}
\title{Internal standard CCA function.}
\usage{
standardCCA(S1, S2, S12, tol = 1e-04)
}
\arguments{
\item{S1}{correlation/covariance matrix of dataset \code{X1}.}

\item{S2}{correlation/covariance matrix of dataset \code{X2}.}

\item{S12}{correlation/covariance matrix between dataset \code{X1} and dataset \code{X2}.}

\item{tol}{tolerance for eigenvalues. \code{standardCCA} function only deals with positive eigenvalues larger than the tolerance.}
}
\value{
\code{standardCCA} returns a data.frame containing
\itemize{
      \item cancor: estimated canonical correlation.
      \item w1: estimated canonical direction \eqn{w1}.
      \item w2: estimated canonical direction \eqn{w2}.
}
}
\description{
This function is modified from original CCA function for two reasons: to deal with only positive eigenvalues larger than the tolerance when calculating the inverse of the matrices and to compute Singular Value Decomposition using \code{\link[irlba]{irlba}} algorithm. Inputs should be correlation or covariance matrices of each data set and between datasets. This function returns only the first pair of canonical covariates.
}
