% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_lsr.R
\name{mixed_lsr}
\alias{mixed_lsr}
\title{Mixed Low-Rank and Sparse Multivariate Regression for High-Dimensional Data}
\usage{
mixed_lsr(
  x,
  y,
  k,
  nstart = 1,
  init_assign = NULL,
  init_lambda = NULL,
  alt_iter = 5,
  anneal_iter = 1000,
  em_iter = 1000,
  temp = 1000,
  mu = 0.95,
  eps = 1e-06,
  accept_prob = 0.95,
  sim_N = 200,
  verbose = TRUE
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{y}{A matrix of responses.}

\item{k}{The number of groups.}

\item{nstart}{The number of random initializations, the result with the maximum likelihood is returned.}

\item{init_assign}{A vector of initial assignments, NULL by default.}

\item{init_lambda}{A vector with the values to initialize the penalization parameter for each group, e.g., c(1,1,1). Set to NULL by default.}

\item{alt_iter}{The maximum number of times to alternate between the classification expectation maximization algorithm and the simulated annealing algorithm.}

\item{anneal_iter}{The maximum number of simulated annealing iterations.}

\item{em_iter}{The maximum number of EM iterations.}

\item{temp}{The initial simulated annealing temperature, temp > 0.}

\item{mu}{The simulated annealing decrease temperature fraction. Once the best configuration cannot be improved, reduce the temperature to (mu)T, 0 < mu < 1.}

\item{eps}{The final simulated annealing temperature, eps > 0.}

\item{accept_prob}{The simulated annealing probability of accepting a new assignment 0 < accept_prob < 1. When closer to 1, trial assignments will only be small perturbation of the current assignment. When closer to 0, trial assignments are closer to random.}

\item{sim_N}{The simulated annealing number of iterations for reaching equilibrium.}

\item{verbose}{A boolean indicating whether to print to screen.}
}
\value{
A list containing the likelihood, the partition, the coefficient matrices, and the BIC.
}
\description{
Mixed Low-Rank and Sparse Multivariate Regression for High-Dimensional Data
}
\examples{
simulate <- simulate_lsr(50)
mixed_lsr(simulate$x, simulate$y, k = 2, init_lambda = c(1,1), alt_iter = 0)
}
