% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_diagnostic_functions.R
\name{coef.mixpoissonreg}
\alias{coef.mixpoissonreg}
\title{Coef Method for \code{mixpoissonreg} Objects.}
\usage{
\method{coef}{mixpoissonreg}(object, parameters = c("all", "mean", "precision"), ...)
}
\arguments{
\item{object}{object of class "mixpoissonreg" containing results from the fitted model.}

\item{parameters}{a string to determine which coefficients should be extracted: 'all' extracts all coefficients, 'mean' extracts the coefficients of the mean parameters and 'precision' extracts coefficients of the precision parameters.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector containing the coefficients of a \emph{mixpoissonreg} object.
}
\description{
Extract model coefficients of fitted mixed Poisson regression models. The parameters arguments allows one to chose if all coefficients should be extracted,
with \code{parameters = 'all'}; if the coefficients of the mean-related parameters should be extracted, with \code{parameters = 'mean'}; if the coefficients of the
precision-related parameters should be extracted, with \code{parameters = 'precision'}.
}
\examples{

daysabs_prog <- mixpoissonreg(daysabs ~ prog, data = Attendance)
coef(daysabs_prog)

}
\seealso{
\code{\link{vcov.mixpoissonreg}}
}
