\name{setMaximumZfromConstant}
\alias{setMaximumZfromConstant}
\title{
Initialize maximum allowable z-axis coordinates to a constant value.
}
\description{
Set the upper bounds in the z-dimension for each location in the x and y
dimensions to a constant value.
}
\usage{
setMaximumZfromConstant(mkde.obj, val)	
}
\arguments{
  \item{mkde.obj}{ 2D or 3D MKDE object created with
    \code{initialize3DMKDE} or \code{initialize3DMKDE}, respectively}
  \item{val}{The value at which the upper bound should be set for all
    locations in the x and y dimensions.}
}
\details{
Obviously, the upper bound must be greater than the lower bound.
}
\value{
An updated MKDE list object is returned.
}
\author{
  Jeff A. Tracey, PhD \cr
  USGS Western Ecological Research Center, San Diego Field Station \cr
  \email{jatracey@usgs.gov}  \cr
  James Sheppard, PhD \cr
  San Diego Zoo Institute for Conservation Research \cr
  \email{jsheppard@sandiegozoo.org}
}
\examples{
library(terra)
fpath <- system.file("extdata", "dugongdem.RDS", package="mkde")
dugongdem <- terra::readRDS(fpath)
cell.sz <- mean(res(dugongdem))
ext <- ext(dugongdem)
nx <- ncol(dugongdem)
ny <- nrow(dugongdem)
mkde.obj <- initializeMKDE3D(ext$xmin, cell.sz, nx, ext$ymin, cell.sz,
ny, min(values(dugongdem), na.rm=TRUE), 50.0, 15)
mkde.obj <- setMaximumZfromConstant(mkde.obj, 100.0)
}
