% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evmetrics_ml.R
\name{Basic metrics}
\alias{Basic metrics}
\alias{hamming_loss}
\alias{subset_accuracy}
\title{Multi-label evaluation metrics}
\usage{
hamming_loss(true_labels, predicted_labels)

subset_accuracy(true_labels, predicted_labels)
}
\arguments{
\item{true_labels}{Matrix of true labels, columns corresponding to labels and
rows to instances.}

\item{predicted_labels}{Matrix of predicted labels, columns corresponding to
labels and rows to instances.}
}
\value{
Resulting value in the range [0, 1]
}
\description{
Several evaluation metrics designed for multi-label problems.
}
\details{
\strong{Available metrics in this category}
\itemize{
 \item \code{hamming_loss}: describes
 the average absolute distance between a predicted label and its true value.
 \item \code{subset_accuracy}: the ratio of correctly predicted labelsets.
}
}
\examples{
true_labels <- matrix(c(
1,1,1,
0,0,0,
1,0,0,
1,1,1,
0,0,0,
1,0,0
), ncol = 3, byrow = TRUE)
predicted_labels <- matrix(c(
1,1,1,
0,0,0,
1,0,0,
1,1,0,
1,0,0,
0,1,0
), ncol = 3, byrow = TRUE)

hamming_loss(true_labels, predicted_labels)
subset_accuracy(true_labels, predicted_labels)
}
\seealso{
\code{\link{mldr_evaluate}}, \code{\link{mldr_to_labels}}

Other evaluation metrics: \code{\link{Averaged metrics}},
  \code{\link{Ranking-based metrics}}
}
\concept{evaluation metrics}
