% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnerRegrRanger.R
\name{mlr_learners_regr.ranger}
\alias{mlr_learners_regr.ranger}
\alias{LearnerRegrRanger}
\title{Ranger Regression Learner}
\description{
Random regression forest.
Calls \code{ranger()} from package \CRANpkg{ranger}.
}
\details{
Additionally to the uncertainty estimation methods provided by the ranger package, the learner provides a ensemble standard deviation and law of total variance uncertainty estimation.
Both methods compute the empirical mean and variance of the training data points that fall into the predicted leaf nodes.
The ensemble standard deviation method calculates the standard deviation of the mean of the leaf nodes.
The law of total variance method calculates the mean of the variance of the leaf nodes plus the variance of the means of the leaf nodes.
Formulas for the ensemble standard deviation and law of total variance method are given in Hutter et al. (2015).

For these 2 methods, the parameter \code{sigma2.threshold} can be used to set a threshold for the variance of the leaf nodes,
this is a minimal value for the variance of the leaf nodes, if the variance is below this threshold, it is set to this value (as described in the paper).
Default is 1e-2.
}
\section{Dictionary}{

This \link[mlr3:Learner]{mlr3::Learner} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary} \link[mlr3:mlr_learners]{mlr3::mlr_learners} or with the associated sugar function \code{\link[mlr3:mlr_sugar]{mlr3::lrn()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_learners$get("regr.ranger")
lrn("regr.ranger")
}\if{html}{\out{</div>}}
}

\section{Meta Information}{

\itemize{
\item Task type: \dQuote{regr}
\item Predict Types: \dQuote{response}, \dQuote{se}, \dQuote{quantiles}
\item Feature Types: \dQuote{logical}, \dQuote{integer}, \dQuote{numeric}, \dQuote{character}, \dQuote{factor}, \dQuote{ordered}
\item Required Packages: \CRANpkg{mlr3}, \CRANpkg{mlr3learners}, \CRANpkg{ranger}
}
}

\section{Parameters}{
\tabular{lllll}{
   Id \tab Type \tab Default \tab Levels \tab Range \cr
   always.split.variables \tab untyped \tab - \tab  \tab - \cr
   holdout \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   importance \tab character \tab - \tab none, impurity, impurity_corrected, permutation \tab - \cr
   keep.inbag \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   max.depth \tab integer \tab NULL \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   min.bucket \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   min.node.size \tab integer \tab 5 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   mtry \tab integer \tab - \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   mtry.ratio \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   na.action \tab character \tab na.learn \tab na.learn, na.omit, na.fail \tab - \cr
   node.stats \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   num.random.splits \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   num.threads \tab integer \tab 1 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   num.trees \tab integer \tab 500 \tab  \tab \eqn{[1, \infty)}{[1, Inf)} \cr
   oob.error \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   poisson.tau \tab numeric \tab 1 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   regularization.factor \tab untyped \tab 1 \tab  \tab - \cr
   regularization.usedepth \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   replace \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   respect.unordered.factors \tab character \tab - \tab ignore, order, partition \tab - \cr
   sample.fraction \tab numeric \tab - \tab  \tab \eqn{[0, 1]}{[0, 1]} \cr
   save.memory \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   scale.permutation.importance \tab logical \tab FALSE \tab TRUE, FALSE \tab - \cr
   se.method \tab character \tab infjack \tab jack, infjack, ensemble_standard_deviation, law_of_total_variance \tab - \cr
   sigma2.threshold \tab numeric \tab 0.01 \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   seed \tab integer \tab NULL \tab  \tab \eqn{(-\infty, \infty)}{(-Inf, Inf)} \cr
   split.select.weights \tab untyped \tab NULL \tab  \tab - \cr
   splitrule \tab character \tab variance \tab variance, extratrees, maxstat, beta, poisson \tab - \cr
   verbose \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
   write.forest \tab logical \tab TRUE \tab TRUE, FALSE \tab - \cr
}
}

\section{Custom mlr3 parameters}{

\itemize{
\item \code{mtry}:
\itemize{
\item This hyperparameter can alternatively be set via our hyperparameter \code{mtry.ratio}
as \code{mtry = max(ceiling(mtry.ratio * n_features), 1)}.
Note that \code{mtry} and \code{mtry.ratio} are mutually exclusive.
}
}
}

\section{Initial parameter values}{

\itemize{
\item \code{num.threads}:
\itemize{
\item Actual default: \code{2}, using two threads, while also respecting environment variable
\code{R_RANGER_NUM_THREADS}, \code{options(ranger.num.threads = N)}, or \code{options(Ncpus = N)}, with
precedence in that order.
\item Adjusted value: 1.
\item Reason for change: Conflicting with parallelization via \CRANpkg{future}.
}
}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(lrn("regr.ranger")$packages, quietly = TRUE)) withAutoprint(\{ # examplesIf}
# Define the Learner and set parameter values
learner = lrn("regr.ranger")
print(learner)

# Define a Task
task = tsk("mtcars")

# Create train and test set
ids = partition(task)

# Train the learner on the training ids
learner$train(task, row_ids = ids$train)

# Print the model
print(learner$model)

# Importance method
if ("importance" \%in\% learner$properties) print(learner$importance)

# Make predictions for the test rows
predictions = learner$predict(task, row_ids = ids$test)

# Score the predictions
predictions$score()
\dontshow{\}) # examplesIf}
}
\references{
Wright, N. M, Ziegler, Andreas (2017).
\dQuote{ranger: A Fast Implementation of Random Forests for High Dimensional Data in C++ and R.}
\emph{Journal of Statistical Software}, \bold{77}(1), 1--17.
\doi{10.18637/jss.v077.i01}.

Breiman, Leo (2001).
\dQuote{Random Forests.}
\emph{Machine Learning}, \bold{45}(1), 5--32.
ISSN 1573-0565, \doi{10.1023/A:1010933404324}.

Hutter, Frank, Xu, Lin, Hoos, H. H, Leyton-Brown, Kevin (2015).
\dQuote{Algorithm runtime prediction: methods and evaluation.}
In \emph{Proceedings of the 24th International Conference on Artificial Intelligence},  series IJCAI'15, 4197--4201.
}
\seealso{
\itemize{
\item Chapter in the \href{https://mlr3book.mlr-org.com/}{mlr3book}:
\url{https://mlr3book.mlr-org.com/chapters/chapter2/data_and_basic_modeling.html#sec-learners}
\item Package \href{https://github.com/mlr-org/mlr3extralearners}{mlr3extralearners} for more learners.
\item \link[mlr3misc:Dictionary]{Dictionary} of \link[mlr3:Learner]{Learners}: \link[mlr3:mlr_learners]{mlr3::mlr_learners}
\item \code{as.data.table(mlr_learners)} for a table of available \link[mlr3:Learner]{Learners} in the running session (depending on the loaded packages).
\item \CRANpkg{mlr3pipelines} to combine learners with pre- and postprocessing steps.
\item Extension packages for additional task types:
\itemize{
\item \CRANpkg{mlr3proba} for probabilistic supervised regression and survival analysis.
\item \CRANpkg{mlr3cluster} for unsupervised clustering.
}
\item \CRANpkg{mlr3tuning} for tuning of hyperparameters, \CRANpkg{mlr3tuningspaces}
for established default tuning spaces.
}

Other Learner: 
\code{\link{mlr_learners_classif.cv_glmnet}},
\code{\link{mlr_learners_classif.glmnet}},
\code{\link{mlr_learners_classif.kknn}},
\code{\link{mlr_learners_classif.lda}},
\code{\link{mlr_learners_classif.log_reg}},
\code{\link{mlr_learners_classif.multinom}},
\code{\link{mlr_learners_classif.naive_bayes}},
\code{\link{mlr_learners_classif.nnet}},
\code{\link{mlr_learners_classif.qda}},
\code{\link{mlr_learners_classif.ranger}},
\code{\link{mlr_learners_classif.svm}},
\code{\link{mlr_learners_classif.xgboost}},
\code{\link{mlr_learners_regr.cv_glmnet}},
\code{\link{mlr_learners_regr.glmnet}},
\code{\link{mlr_learners_regr.kknn}},
\code{\link{mlr_learners_regr.km}},
\code{\link{mlr_learners_regr.lm}},
\code{\link{mlr_learners_regr.nnet}},
\code{\link{mlr_learners_regr.svm}},
\code{\link{mlr_learners_regr.xgboost}}
}
\concept{Learner}
\section{Super classes}{
\code{\link[mlr3:Learner]{mlr3::Learner}} -> \code{\link[mlr3:LearnerRegr]{mlr3::LearnerRegr}} -> \code{LearnerRegrRanger}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LearnerRegrRanger-new}{\code{LearnerRegrRanger$new()}}
\item \href{#method-LearnerRegrRanger-importance}{\code{LearnerRegrRanger$importance()}}
\item \href{#method-LearnerRegrRanger-oob_error}{\code{LearnerRegrRanger$oob_error()}}
\item \href{#method-LearnerRegrRanger-selected_features}{\code{LearnerRegrRanger$selected_features()}}
\item \href{#method-LearnerRegrRanger-clone}{\code{LearnerRegrRanger$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="base_learner"><a href='../../mlr3/html/Learner.html#method-Learner-base_learner'><code>mlr3::Learner$base_learner()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="configure"><a href='../../mlr3/html/Learner.html#method-Learner-configure'><code>mlr3::Learner$configure()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="encapsulate"><a href='../../mlr3/html/Learner.html#method-Learner-encapsulate'><code>mlr3::Learner$encapsulate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="format"><a href='../../mlr3/html/Learner.html#method-Learner-format'><code>mlr3::Learner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="help"><a href='../../mlr3/html/Learner.html#method-Learner-help'><code>mlr3::Learner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict"><a href='../../mlr3/html/Learner.html#method-Learner-predict'><code>mlr3::Learner$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="predict_newdata"><a href='../../mlr3/html/Learner.html#method-Learner-predict_newdata'><code>mlr3::Learner$predict_newdata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="print"><a href='../../mlr3/html/Learner.html#method-Learner-print'><code>mlr3::Learner$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="reset"><a href='../../mlr3/html/Learner.html#method-Learner-reset'><code>mlr3::Learner$reset()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Learner" data-id="train"><a href='../../mlr3/html/Learner.html#method-Learner-train'><code>mlr3::Learner$train()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="LearnerRegr" data-id="predict_newdata_fast"><a href='../../mlr3/html/LearnerRegr.html#method-LearnerRegr-predict_newdata_fast'><code>mlr3::LearnerRegr$predict_newdata_fast()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-new"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-importance"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-importance}{}}}
\subsection{Method \code{importance()}}{
The importance scores are extracted from the model slot \code{variable.importance}.
Parameter \code{importance.mode} must be set to \code{"impurity"}, \code{"impurity_corrected"}, or
\code{"permutation"}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$importance()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Named \code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-oob_error"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-oob_error}{}}}
\subsection{Method \code{oob_error()}}{
The out-of-bag error, extracted from model slot \code{prediction.error}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$oob_error()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{numeric(1)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-selected_features"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-selected_features}{}}}
\subsection{Method \code{selected_features()}}{
The set of features used for node splitting in the forest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$selected_features()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LearnerRegrRanger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LearnerRegrRanger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LearnerRegrRanger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
