% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary_control}
\alias{summary_control}
\title{Control for Learner summaries}
\usage{
summary_control(
  measures = NULL,
  complexity_measures = c("sparsity", "interaction_strength"),
  importance_measures = NULL,
  n_important = 15L,
  effect_measures = c("pdp", "ale"),
  fairness_measures = NULL,
  protected_attribute = NULL,
  hide = NULL,
  digits = max(3L, getOption("digits") - 3L)
)
}
\arguments{
\item{measures}{(\link[mlr3:Measure]{mlr3::Measure} | list of \link[mlr3:Measure]{mlr3::Measure} | NULL)\cr
measure(s) to calculate performance on. If NULL (default), a set of
selected measures are calculated (choice depends on Learner type (classif vs. regr)).
See details below.}

\item{complexity_measures}{(character)\cr
vector of complexity measures. Possible choices are "sparsity" (the number
of used features) and "interaction_strength" (see Molnar et al. (2020)).
Both are the default. See details below.}

\item{importance_measures}{(character()|NULL)\cr
vector of importance measure names. Possible choices are "pfi.\code{<}loss\code{>}"
(\link[iml:FeatureImp]{iml::FeatureImp}), "pdp" (\link[iml:FeatureEffects]{iml::FeatureEffects}, see ) and
"shap" (\link[fastshap:explain]{fastshap::explain}). Default of NULL results in "pfi.\code{<}loss\code{>}" and
"pdp", where the \code{<}loss\code{>} depends on the Learner type (classif vs. regr).
See details below.}

\item{n_important}{(numeric(1))\cr
number of important variables to be displayed. Default is 15L.}

\item{effect_measures}{(character | NULL)\cr
vector of effect method names. Possible choices are "pfi" and "ale"
(see \link[iml:FeatureEffects]{iml::FeatureEffects}). Both are the default. See details below.}

\item{fairness_measures}{(\link[mlr3fairness:MeasureFairness]{mlr3fairness::MeasureFairness} |
list of \link[mlr3fairness:MeasureFairness]{mlr3fairness::MeasureFairness} | NULL)\cr
measure(s) to assess fairness. If NULL (default), a set of
selected measures are calculated (choice depends on Learner type (classif vs. regr)).
See details below.}

\item{protected_attribute}{(character(1))\cr
name of the binary feature that is used as a protected attribute.
If no \code{protected_attribute} is specified (and also no \code{pta} feature is
available in the \code{mlr3::Task} for training the \code{mlr3::Learner}),
no fairness metrics are computed.}

\item{hide}{(character)\cr
names of paragraphs which should not be part of the summary.
Possible values are "general", "residuals", "performance", "complexity", "fairness",
"importance", "effect". If NULL, no paragraph is hided.}

\item{digits}{(numeric(1))\cr
number of digits to use when printing.}
}
\value{
\link{list} of class \code{summary_control}
}
\description{
Various parameters that control aspects of \code{summary.Learner}.
}
\details{
The following provides some details on the different choices of measures.

\strong{Performance}
The default \code{measures} depend on the type of task. Therefore, NULL is displayed as default and
the measures will be initialized in \code{summary.Learner} with the help of \code{mlr3::msr}.
The following provides an overview of these defaults:
\itemize{
\item{Regression: \link[mlr3:mlr_measures_regr.rmse]{regr.rmse},
\link[mlr3:mlr_measures_regr.rsq]{regr.rsq},
\link[mlr3:mlr_measures_regr.mae]{regr.mae},
\link[mlr3:mlr_measures_regr.medae]{regr.medae}}
\item{Binary classification with probabilities:
\link[mlr3:mlr_measures_classif.auc]{classif.auc},
\link[mlr3:mlr_measures_classif.fbeta]{classif.fbeta},
\link[mlr3:mlr_measures_classif.bbrier]{classif.bbrier},
\link[mlr3:mlr_measures_classif.mcc]{classif.mcc}}
\item{Binary classification with hard labels:
\link[mlr3:mlr_measures_classif.acc]{classif.acc},
\link[mlr3:mlr_measures_classif.bacc]{classif.bacc},
\link[mlr3:mlr_measures_classif.fbeta]{classif.fbeta},
\link[mlr3:mlr_measures_classif.mcc]{classif.mcc}}
\item{Multi-class classification with probabilities:
\link[mlr3:mlr_measures_classif.mauc_aunp]{classif.mauc_aunp},
\link[mlr3:mlr_measures_classif.mbrier]{classif.mbrier}}
}
\strong{Complexity}
Currently only two \code{complexity_measures} are available, which are
based on Molnar et al. (2020):
\itemize{
\item{\code{sparsity}: The number of used features, that have a non-zero effect
on the prediction (evaluated by accumulated local effects (ale, Apley and Zhu
(2020)). The measure can have values between 0 and the number of features.}
\item{\code{interaction_strength}: The scaled approximation error between a
main effect model (based on ale) and the prediction function. It can have
values between 0 and 1, where 0 means no interaction and 1 only interaction,
and no main effects. Interaction strength can only be measured for binary
classification and regression models.}
}

\strong{Importance} The \code{importance_measures} are based on the \code{iml} and
\code{fastshap} packages. Multiple measures are available:
\itemize{
\item{pdp: This corrensponds to importances based on the standard deviations
in partial dependence plots (Friedmann (2001)), as proposed by Greenwell et al. (2018).}
\item{pfi.\code{<}loss\code{>}: This corresponds to the permutation feature importance as
implemented in \link[iml:FeatureImp]{iml::FeatureImp}. Different loss functions are possible and
rely on the task at hand.}
\item{shap: This importance corresponds to the
mean absolute Shapley values computed with \link[fastshap:explain]{fastshap::explain}.
Higher values display higher importance.}
}
NULL is the default, corresponding to importance calculations based on pdp and pfi.
Because the loss function for pfi relies on the task at hand, the importance measures
are initialized in \code{summary}."pdp" and "pfi.ce" are the defaults for
classification, "pdp" and "pfi.mse" for regression.

\strong{Effects} The \code{effect_measures} are based on \link[iml:FeatureEffects]{iml::FeatureEffects}.
Currently partial dependence plots (pdp) and accumulated local effects are
available (ale). Ale has the advantage over pdp that it takes feature
correlations into account but has a less natural interpretation than pdp.
Therefore, both "pdp" and "ale" are the defaults.

\strong{Fairness}
The default \code{fairness_measures} depend on the type of task.
Therefore, NULL is displayed as default and
the measures will be initialized in \code{summary.Learner} based on
\link[mlr3fairness:mlr_measures_fairness]{mlr3fairness::mlr_measures_fairness}.
There is currently a mismatch between the naming convention of
measures in \code{mlr3fairness} and the underlying measurements displayed.
To avoid confusion, the id of the fairness measures were adapted.
The following provides an overview of these defaults and adapted names:
\itemize{
\item{Binary classification: "fairness.dp" (demographic parity) based on "fairness.cv",
"fairness.cuae" (conditional use accuracy equality) based on "fairness.pp",
"fairness.eod" (equalized odds) based on "fairness.eod". Smaller values are better.}
\item{Multi-class classification: "fairness.acc", the smallest absolute
difference in accuracy between groups of the \code{protected_attribute}.
Smaller values are better.}
\item{Regression: "fairness.rmse" and "fairness.mae",
the smallest absolute difference (see \link[mlr3fairness:groupdiff_tau]{mlr3fairness::groupdiff_absdiff})
in the either the root mean-squared error (rmse) or
the mean absolute error (mae) between groups of the \code{protected_attribute}.
Smaller values are better.}
}
}
\references{
Molnar, Christoph, Casalicchio, Giuseppe, Bischl, Bernd (2020).
\dQuote{Quantifying Model Complexity via Functional Decomposition for Better Post-hoc Interpretability.}
In \emph{Communications in Computer and Information Science}, chapter 1, 193--204.
Springer International Publishing.

Greenwell, M. B, Boehmke, C. B, McCarthy, J. A (2018).
\dQuote{A Simple and Effective Model-Based Variable Importance Measure.}
arXiv preprint.
arXiv:1805.04755, \url{http://arxiv.org/abs/1805.04755}.

Apley, W. D, Zhu, Jingyu (2020).
\dQuote{Visualizing the Effects of Predictor Variables in Black Box Supervised Learning Models.}
\emph{Journal of the Royal Statistical Society Series B: Statistical Methodology}, \bold{82}(4), 1059-1086.

Friedman, H. J (2001).
\dQuote{Greedy Function Approximation: A Gradient Boosting Machine.}
\emph{The Annals of Statistics}, \bold{29}(5).
}
