% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09-opal_functions.R
\name{opal_tables_push}
\alias{opal_tables_push}
\title{Upload datasets into an Opal environment as tables in an Opal project}
\usage{
opal_tables_push(
  opal,
  dossier = NULL,
  data_dict = NULL,
  dataset = NULL,
  table_name = NULL,
  project_name,
  .force = FALSE,
  .overwrite = FALSE
)
}
\arguments{
\item{opal}{Opal login attributes.}

\item{dossier}{List of data frame, each of them being datasets.}

\item{data_dict}{A list of tibble(s) representing metadata of an
associated dataset. Automatically generated if not provided.}

\item{dataset}{A tibble identifying the dataset observations associated to
its data dictionary.}

\item{table_name}{A character string specifying an Opal table name.}

\item{project_name}{A character string specifying the Opal project name.}

\item{.force}{If the destination already exists, stop with an informative
message if this flag is FALSE (default).}

\item{.overwrite}{If the destination table already exists, it will be
replaced (deleted, re-created with associated permissions reinstated and then
imported). Otherwise the table will be updated (data dictionaries merge may
conflict). Default is FALSE.*}
}
\value{
A table or table(s) in Opal.
}
\description{
Uploads a dossier or dataset from the local environment to an Opal
environment. This is a wrapper function for \code{\link[opalr:opal.table_create]{opalr::opal.table_create()}},
\code{\link[opalr:opal.table_save]{opalr::opal.table_save()}} and \code{\link[opalr:opal.table_dictionary_update]{opalr::opal.table_dictionary_update()}}.
}
\details{
Opal is the OBiBa application for data management, and Opal environments can
be integrated with RStudio environments using the package \code{opalr}.
The user must have adequate credentials to interact with a specific Opal
environment. Some function errors produced may be associated with the
handler or Opal read/write permissions.
}
\examples{
\dontrun{

library(opalr)
opal <- 
 opal.login('administrator','password',
   url ='https://opal-demo.obiba.org/')
    
# use madshapR_DEMO provided by the package
library(madshapR)
library(stringr)
dataset <- madshapR_DEMO$dataset_MELBOURNE
    
tempdir <- basename(tempdir())
try(opal_project_create(opal, tempdir))

# push a table in a project.
try(
  opal_tables_push(
  opal,
  dataset = dataset,
  table_name = 'MELBOURNE',
  project_name = tempdir,
  .force = TRUE,
  .overwrite = TRUE))

}

}
\seealso{
Please see \href{https://opaldoc.obiba.org/}{Opal documentation} for
complete documentation.
\code{\link[madshapR:as_dossier]{madshapR::as_dossier()}}
\code{\link[madshapR:as_dataset]{madshapR::as_dataset()}}
\code{\link[madshapR:as_data_dict_mlstr]{madshapR::as_data_dict_mlstr()}}
}
