% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_fordistribution.R
\name{d_offspringdistn}
\alias{d_offspringdistn}
\alias{p_offspringdistn}
\alias{q_offspringdistn}
\alias{r_offspringdistn}
\title{The offspring distribution}
\usage{
d_offspringdistn(
  x = 1,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  is.log = FALSE
)

p_offspringdistn(
  q = 1.5,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  is.log = FALSE,
  lower.tail = TRUE
)

q_offspringdistn(
  p = 0.8,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D",
  lower.tail = TRUE
)

r_offspringdistn(
  n = 10,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = "D"
)
}
\arguments{
\item{x}{A scalar, or a vector of non-negative integer.}

\item{epi.para}{A list (\code{list}) of pre-defined epidemiological parameters for offspring distribution, in the format of \code{list(mean = ?, disp = ?, shift = ?)},
where the three parameters accept non-negative values.
Each parameter can be either a scalar, or a vector.
For the parameters being assigned with values of vectors, the vectors should be of the same length.
For Delaporte distribution, the value of \code{mean} should be larger than the value of \code{shift}.}

\item{offspring.type}{A character label (\code{character}) indicating the type of distribution used to describe the offspring distribution.
It only accepts one of the following values:
\itemize{
\item{\code{"D"}}{ indicates the \emph{Delaporte} distribution, }
\item{\code{"NB"}}{ indicates the \emph{negative binomial} distribution, }
\item{\code{"G"}}{ indicates the \emph{geometric} distribution, or }
\item{\code{"P"}}{ indicates the \emph{Poisson} distribution. }
}
By default, \code{offspring.type = 'D'}.}

\item{is.log}{A logical variable, under which probability would be taken natural logarithm, if \code{is.log = TRUE}.
By default, \code{is.log = FALSE}.}

\item{q}{A scalar, or a vector of non-negative number (not necessarily integer).}

\item{lower.tail}{A logical variable, under which the probability is cumulative distribution function (CDF, i.e., \emph{P(X <= x)}), if \code{lower.tail = TRUE}, and otherwise, 1 - CDF (i.e., \emph{P(X > x)}).
By default, \code{lower.tail = TRUE}.}

\item{p}{A scalar, or a vector of probability (i.e., ranging from 0 to 1).}

\item{n}{A scalar of positive integer.}
}
\value{
For the values returned from the four functions,
\itemize{
\item{\code{d_offspringdistn()}}{ is the \emph{probability mass function} (PMF), and it returns value of probability (i.e., ranging from 0 to 1); }
\item{\code{p_offspringdistn()}}{ is the \emph{cumulative distribution function} (CDF), and it returns value of probability (i.e., ranging from 0 to 1); }
\item{\code{q_offspringdistn()}}{ is the \emph{quantile function}, and it returns value of quantile (non-negative integer); and }
\item{\code{r_offspringdistn()}}{ is the \emph{random variable generating function}, and it generates a set of \code{n} random variables (non-negative integers). }
}
}
\description{
Density, cumulative distribution, quantile, and random variable generating functions for the \strong{offspring} distribution with pre-defined epidemiological parameters.
}
\details{
For different values of \code{offspring.type},
\itemize{
\item{When \code{offspring.type = "D"},}{ no action to any parameter; }
\item{When \code{offspring.type = "NB"},}{ we set parameter \code{shift = 0}; }
\item{When \code{offspring.type = "G"},}{ we set parameters \code{disp = 1} and \code{shift = 0}; and }
\item{When \code{offspring.type = "P"},}{ we set parameters \code{disp = +Inf} and \code{shift = mean}. }
}
}
\note{
Depending on the values of parameters, the functions could take hours to complete, given the double-summation nature for the Delaporte distribution.
}
\examples{
## Please see the "Usage" section.


## the following returns the proportion of index cases that generated at least 1 offspring cases.
p_offspringdistn(
  q = 0,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = 'D', lower.tail = FALSE
)

## reproducing the results in Adam, et al. (2020)
## paper doi link: https://doi.org/10.1038/s41591-020-1092-0 (see Fig 3b),
## where the number of offspring cases were fitted
## with parameter R of 0.58 and k of 0.43 under NB distribution.
data(COVID19_JanApr2020_HongKong)
hist(
  COVID19_JanApr2020_HongKong$obs, breaks = c(0:100) -0.5, xlim = c(0,12),
  freq = FALSE, xlab = 'secondary cases', ylab = 'rel. freq.', main = ''
)
lines(0:12, d_offspringdistn(
  x = 0:12,
  epi.para = list(mean = 0.58, disp = 0.43, shift = 0.2),
  offspring.type = "NB"
), pch = 20, type = 'o', lty = 2)


## an example to generate 100 rv of offspring case number
table(r_offspringdistn(
  n = 100,
  epi.para = list(mean = 1, disp = 0.5, shift = 0.2),
  offspring.type = 'D'
))

}
\references{
Vose D. Risk analysis: a quantitative guide. John Wiley & Sons. 2008; pp. 618-619. ISBN: 978-0-470-51284-5

Lloyd-Smith JO, Schreiber SJ, Kopp PE, Getz WM. Superspreading and the effect of individual variation on disease emergence. \emph{Nature}. 2005;438(7066):355-359.
\doi{10.1038/nature04153}

Zhao S, Chong MK, Ryu S, Guo Z, He M, Chen B, Musa SS, Wang J, Wu Y, He D, Wang MH. Characterizing superspreading potential of infectious disease: Decomposition of individual transmissibility. \emph{PLoS Computational Biology}. 2022;18(6):e1010281.
\doi{10.1371/journal.pcbi.1010281}
}
\seealso{
\code{\link[Delaporte:ddelap]{Delaporte}} for the parameterization of Delaporte distribution.
}
