% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inverse_transformation.R
\name{rbi_normal_transform_inv}
\alias{rbi_normal_transform_inv}
\title{Inverse of rank based inverse normal transformation}
\usage{
rbi_normal_transform_inv(x, x_original)
}
\arguments{
\item{x}{a numeric vector.}

\item{x_original}{a numeric vector from the original dataset}
}
\value{
A numeric vector with inverse transformed values
}
\description{
Transforms a vector \code{x} using the inverse of rank based inverse normal 
transformation associated with a given vector \code{x_original}. This inverse
is defined as \eqn{F_n^{-1}\Phi(x)}, where \eqn{F_n^{-1}} is the inverse 
empirical cumulative distribution function of \code{x_original} and 
\eqn{\Phi} is the cumulative distribution function of a standard normal 
random variable.
}
\examples{
data("Cleveland",package="modgo")
test_rank <- rbi_normal_transform(Cleveland[,1])
test_inv_rank <- rbi_normal_transform_inv(x = test_rank,
                                          x_original = Cleveland[,1])



}
\author{
Andreas Ziegler, Francisco M. Ojeda, George Koliopanos
}
\keyword{Inverse}
\keyword{transformation}
