#'bfi data
#'
#'Composite scores on the Big 5 personality dimensions and gender. Adapted from
#'the \code{bfi} data in the \code{psychTools} package.
#'
#'@format A data frame with six variables representing composite scores
#'  forparticipants across the Big 5 personality dimensions as well as gender.
#'  \code{A} is Agreeableness, \code{C} is conscientiousness, \code{E} is
#'  extraversion, \code{N} is neuroticism, and \code{O} is openness to
#'  experience. For a given participant, each value represents the mean of 5
#'  self report items from the associated scale. Response values range from
#'  \code{0} to \code{6}. In total, 7 negatively-worded items were reverse
#'  scored before calculating scale composites. \code{gender} is a binary
#'  variable coded such that \code{0 = Males}, and \code{1 = Females}.
#'
#'@source The items are from the IPIP (Goldberg, 1999). The data are from the
#'  SAPA project (Revelle, Wilt and Rosenthal, 2010) , collected Spring, 2010 (
#'  https://www.sapa-project.org/).
#'
#'@references
#'
#'Goldberg, L.R. (1999) A broad-bandwidth, public domain, personality inventory
#'measuring the lower-level facets of several five-factor models. In Mervielde,
#'I. and Deary, I. and De Fruyt, F. and Ostendorf, F. (eds) Personality
#'psychology in Europe. 7. Tilburg University Press. Tilburg, The Netherlands.
#'
#'Revelle, W., Wilt, J., and Rosenthal, A. (2010) Individual Differences in
#'Cognition: New Methods for examining the Personality-Cognition Link In
#'Gruszka, A. and Matthews, G. and Szymura, B. (Eds.) Handbook of Individual
#'Differences in Cognition: Attention, Memory and Executive Control, Springer.
#'
"bfiDat"


#' Simulated GGM data
#'
#' Data generated from \code{\link{simNet}}, with five variables that serve as
#' nodes in the GGM and a sixth that serves as a moderator.
#'
#' @format A \code{5000 x 6} data frame with five variables as nodes in a GGM
#'   and a sixth as a moderator. Attributes contain values for the data
#'   generating model. \code{b1} contains the pairwise network, while \code{b2}
#'   contains the interaction matrix. \code{intercepts} contain the population
#'   means of the five node variables. \code{m} contains the population mean of
#'   the moderator. \code{m1} contains the main effect coefficients for the
#'   moderator predicting each of the five nodes.
"ggmDat"

#' Simulated temporal network data
#'
#' Data generated from \code{\link{simNet}}, with five variables that serve as
#' nodes in the GVAR model and a sixth that serves as a moderator. The data were
#' generated by setting \code{lag = 1} to specify a single-subject lag-1 model.
#' The data were simulated from a graphical vector autoregressive model (GVAR).
#'
#' In the case of using \code{simNet} with \code{lags = 1}, that function
#' essentially serves as a wrapper for \code{\link{mlGVARsim}} which
#' automatically sets \code{nPerson = 1}.
#'
#' @format A \code{5000 x 6} data frame with five variables as nodes in a GVAR
#'   and a sixth as a moderator. Attributes contain values for the data
#'   generating model.
"gvarDat"

#' Simulated multi-level network data
#'
#' Data generated from \code{\link{mlGVARsim}}, with five variables that serve
#' as nodes in the multi-level GVAR model, one moderator variable, and an ID
#' variable that distinguishes between subjects.
#'
#' @format A \code{50000 x 7} data frame with five variables to serve as nodes in
#'   the networks, one variable \code{"M"} to serve as the time-lagged
#'   moderator, and an \code{ID} variable that labels responses from each of
#'   \code{100} simulated individuals. For each ID number, there are 500
#'   time-ordered responses.
"mlgvarDat"
