% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitNetwork.R
\name{getFitCIs}
\alias{getFitCIs}
\title{Provides model coefficients with confidence intervals}
\usage{
getFitCIs(fit, allNames = NULL, alpha = 0.05)
}
\arguments{
\item{fit}{Output from \code{\link{fitNetwork}}, or either the
\code{fixedNets} or \code{betweenNet} element of the output from
\code{\link{mlGVAR}}}

\item{allNames}{Character vector containing all the predictor names. Do not
change, as these are automatically detected.}

\item{alpha}{Type 1 error rate. The complement of the confidence level.}
}
\value{
List of tables containing model coefficients along with confidence
intervals
}
\description{
Requires that either \code{fitobj} or \code{SURfit} is included in the object
from \code{\link{fitNetwork}}. Returns a list of nodewise model coefficients,
including confidence intervals computed from the estimated standard errors.
}
\details{
The \code{select} column in the output indicates whether the variable would
be selected given the supplied alpha level.
}
\examples{
x <- fitNetwork(ggmDat)
getFitCIs(x)
}
\seealso{
\code{\link{fitNetwork}, \link{plotCoefs}}
}
