% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plotNet3}
\alias{plotNet3}
\title{Plot temporal, contemporaneous, and between-subject networks}
\usage{
plotNet3(
  object,
  ...,
  nets = c("temporal", "contemporaneous", "between"),
  titles = TRUE,
  l = 3,
  label = NULL,
  xpos = 0,
  ypos = 0.5
)
}
\arguments{
\item{object}{Output from \code{\link{mlGVAR}} or \code{\link{lmerVAR}}.}

\item{...}{Additional arguments.}

\item{nets}{Character vector of length 3 indicating which networks to plot,
and in what order. Same options as for \code{which.net} in
\code{\link{plotNet}}.}

\item{titles}{If \code{TRUE}, then uses default titles for temporal,
contemporaneous, and between-subject networks. If \code{FALSE}, then no
titles will be used. Can also be a character vector to provide custom plot
titles.}

\item{l}{A numeric value to indicate a type of pane layout.}

\item{label}{Can include a character string for text annotation.}

\item{xpos}{Numeric, x-axis value for where the text annotation should go.
Between 0 and 1.}

\item{ypos}{numeric, y-axis value for where the text annotation should go.
Between 0 and 1.}
}
\value{
Returns 3 network plots.
}
\description{
Quick, easy plotting for \code{\link{mlGVAR}} and \code{\link{lmerVAR}}
output. Allows one to plot three networks in the same window: temporal,
contemporaneous, and between-subject.
}
\examples{
\donttest{
x <- mlGVAR(mlgvarDat, 'M')
plotNet3(x)
}
}
\seealso{
\code{\link{mlGVAR}, \link{lmerVAR}}
}
