% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DNE3dDiscard.R
\name{DNE3dDiscard}
\alias{DNE3dDiscard}
\title{Plot discarded-face results of a DNE analysis (HTML widget; no Quartz)}
\usage{
DNE3dDiscard(
  DNE_File,
  baseCol = "gray",
  boundCol = "red",
  outlierCol = "lawngreen",
  concaveCol = baseCol,
  main = "",
  cex = 1,
  legend = TRUE,
  widget_size_px = 768,
  scene_zoom = 1.5,
  leftOffset = 0,
  fieldofview = 0,
  title_font_size_px = 30,
  legend_magnify = 1,
  legendTextCol = "black",
  legendLineCol = "black",
  fileName = NA,
  binary = FALSE
)
}
\arguments{
\item{DNE_File}{An object that stores the output of \code{DNE()}}

\item{baseCol}{Base color for typical faces (default \code{"gray"})}

\item{boundCol}{Color for boundary faces discarded from DNE (default \code{"red"})}

\item{outlierCol}{Color for faces discarded as outliers (default \code{"lawngreen"})}

\item{concaveCol}{Color for concave faces; when left equal to \code{baseCol} the
concave category is not distinguished or shown in the legend (default = \code{baseCol})}

\item{main}{Character; plot title (default \code{""})}

\item{cex}{Numeric; relative size multiplier for legend text (default \code{1})}

\item{legend}{Logical; show legend panel (default \code{TRUE})}

\item{widget_size_px}{Integer; square size of the 3D widget in pixels (default \code{768})}

\item{scene_zoom}{Numeric; initial zoom on the 3D scene (default \code{1.5})}

\item{leftOffset}{Numeric (-1..1); small horizontal camera nudge (default \code{0})}

\item{fieldofview}{Numeric; field of view in degrees; 0 = isometric (default \code{0})}

\item{title_font_size_px}{Integer; title font size in pixels (default \code{30})}

\item{legend_magnify}{Numeric; additional legend scale factor (default \code{1})}

\item{legendTextCol}{Color for legend text (default \code{"black"})}

\item{legendLineCol}{Color for legend swatch borders/lines (default \code{"black"})}

\item{fileName}{Character or \code{NA}; if non-\code{NA}, write a colorized *.ply to disk (default \code{NA})}

\item{binary}{Logical; write PLY as binary (default \code{FALSE}, i.e., ascii)}
}
\value{
An htmltools-browsable object containing the title, 3D widget, and legend.
}
\description{
Produces a three-dimensional rendering that highlights the faces discarded from
the DNE calculation---boundary faces and statistical outliers---along with optional
concavity marking. The plot is returned as an HTML widget with a simple, readable
legend panel to the right.
}
\details{
Run \code{DNE()} first to compute per-face values and discard sets.

\strong{What this shows}
\itemize{
\item \emph{Boundary faces} (e.g., with >=1 boundary vertex) and \emph{outlier faces} (top extreme
tail) that were excluded from DNE are colored distinctly; all other faces get
\code{baseCol}. If \code{concaveCol} differs from \code{baseCol}, concave regions are tinted
accordingly and labeled in the legend.
}

\strong{HTML widget}
\itemize{
\item Uses a headless rgl device and returns an \code{rglwidget} embedded beside a simple HTML
legend (no Quartz window). Layout and centering mirror the updated \code{DNE3d}.
}

\strong{Saving a PLY}
\itemize{
\item If \code{fileName} is provided, a colorized PLY is written. For ascii PLY, a comment
line noting the generator/version is inserted (as in the updated \code{DNE3d}).
}
}
\examples{
# DNE_out <- DNE(Tooth)
if(interactive()){DNE3dDiscard(DNE_out, main = "DNE -- Discarded Faces")}

}
