% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pos.R
\name{find_pos}
\alias{find_pos}
\title{Find Positivity Threshold}
\usage{
find_pos(pos_thld, events, rand_ratio, hr_null, hr_alt, which_crit, targ)
}
\arguments{
\item{pos_thld}{Numeric. The initial positivity threshold.}

\item{events}{Numeric vector of length 2. The number of events at each analysis.}

\item{rand_ratio}{Numeric. The randomization ratio.}

\item{hr_null}{Numeric. The hazard ratio under the null hypothesis.}

\item{hr_alt}{Numeric. The hazard ratio under the alternative hypothesis.}

\item{which_crit}{Integer. The criterion to be used for finding the positivity threshold:
\itemize{
\item 1: False positive / False negative equals required value.
\item 2: False positive / (False negative + False positive) equals required value.
\item 3: False positive equals required value.
\item 4: Predictive probability equals required value.
}}

\item{targ}{Numeric. The target value for the chosen criterion.}
}
\value{
Numeric. The calculated positivity threshold based on the specified criterion.
}
\description{
This function calculates the positivity threshold based on various criteria.
}
\examples{
find_pos(
  pos_thld = 1.5,
  events = c(100, 200),
  rand_ratio = 1,
  hr_null = 1,
  hr_alt = 1.5,
  which_crit = 1,
  targ = 0.05
)

}
