% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_HELPERS.R
\name{monobin.run}
\alias{monobin.run}
\title{Run monobin algorithm for the selected inputs}
\usage{
monobin.run(algo, target.n, rf, sc, args.e, db)
}
\arguments{
\item{algo}{Binning algorithm from monobin package.}

\item{target.n}{Selected target.}

\item{rf}{Vector of a selected numeric risk factors.}

\item{sc}{Numeric vector of special case values.}

\item{args.e}{Argument elements of the selected monobin function.}

\item{db}{Data frame of target and numeric risk factors.}
}
\value{
Returns a list of two data frame. The first data frame contains the results of implemented
binning algorithm, while the second one contains transformed risk factors.
}
\description{
Run monobin algorithm for the selected inputs
}
\examples{
if 	(interactive()) {
	tbls <- withProgress(message = "Running the binning algorithm", 
					   value = 0, {
			  	  suppressWarnings(
			  	  monobin.run(algo = bin.algo, 
						  target.n = isolate(input$trg.select), 
						  rf = isolate(input$rf.select), 
						  sc = scr.check.res[[1]], 
						  args.e = args.e, 
						  db = isolate(rv$db))
		  )})

	}

}
