#' @name SurvFit
#' 
#' @title Plotting method for \code{SurvFit} objects
#'
#' @description
#' This is the generic \code{plot} S3 method for the \code{SurvFit} class. It
#' plots concentration-response fit under target time survival analysis.
#'
#' @keywords plot
#' 
#' @param x a \code{\link{SurvFit}} object
#' @param xlab label of the x-axis, default is "Time",
#' @param ylab label of the y-axis, default is "Number of Survival"
#' @param main title of the plot, defaul is \code{NULL},
#' @param add_data to add original data to the plot. Default ir \code{TRUE}
#' @param add_legend add legend to the plot, default is \code{FALSE}
#' 
#' @return an object of class \code{ggplot}, see function \code{\link[ggplot2]{ggplot}}
#'
#' @export
plot.SurvFit <- function(x,
                         xlab = "Time",
                         ylab = "Number of Survival",
                         main = NULL,
                         add_data = TRUE,
                         add_legend = FALSE,
                         ...) {

    df_Nsurv <- extract_Nsurv_sim(x)
    
    plt <- ggplot(data = df_Nsurv) + 
        theme_minimal() + 
        labs(x = xlab, y = ylab, title = main)
    
    plt <- plt +
        geom_ribbon(aes(x = time, ymin = qinf95, ymax = qsup95), fill = fillci) +
        geom_line(aes(x = time, y = q50), color = colmed) +
        facet_grid(~ replicate)
    if (add_data) {
        plt <- plt +
            geom_point(aes(x = time, y = Nsurv), color = "black")
    }
    return(plt)
}
