% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-SurvFit.R
\name{Extract}
\alias{Extract}
\alias{extract_Nsurv_ppc}
\alias{extract_Nsurv_sim}
\alias{extract_param}
\alias{priors_distribution}
\alias{priors_distribution.SurvFit}
\title{Extraction methods to recover output of fit object.}
\usage{
extract_Nsurv_ppc(fit)

extract_Nsurv_sim(fit)

extract_param(fit)

priors_distribution(fit, ...)

\method{priors_distribution}{SurvFit}(fit, size_sample = 1000, ...)
}
\arguments{
\item{fit}{An object of class \code{SurvFit}}

\item{\dots}{Further arguments to be passed to generic methods}

\item{size_sample}{Size of the random generation of the distribution.}
}
\value{
a \code{data.frame} with the extracted object from stanfit.
}
\description{
\itemize{
\item \strong{extract_Nsurv_ppc}: extract the \code{Nsurv} generated with the sampler.
To be used for the Posterior Predictive Check (PPC).
\item \strong{extract_Nsurv_sim}: extract the \code{Nsurv} generated with the sampler.
To be used for the Simulation (sim).
\item \strong{extract_param}: extract parameters of \code{SD} or \code{IT} models.
\item \strong{priors_distribution}: Return a \code{data.frame} with prior density
distributions of parameters used in the model.
}
}
