test_that("Constant Exposure", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    data("propiconazole")
    cd <- survData(propiconazole)
    expect_no_error({
        cd_SDfit <- fit(cd, model_type = "SD")
    })
    expect_no_error({
        cd_ITfit <- fit(cd, model_type = "IT")
    })
})

test_that("Variable Exposure", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    data("propiconazole_pulse_exposure")
    vd <- survData(propiconazole_pulse_exposure)
    skip('skip: very long to run Bayes inference (>30min)')
    expect_no_error({
        vd_SDfit <- fit(vd, model_type = "SD", chains = 1, iter = 50)
    })
    expect_no_error({
        vd_ITfit <- fit(vd, model_type = "IT", chains = 1, iter = 50)
    })
})