test_that("multiplication works", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))
    
    data("FOCUSprofile")
    profile = FOCUSprofile[FOCUSprofile$time < 6,]
    display.exposure = data.frame(
        time = profile$time,
        conc = profile$conc / 1000,
        replicate = 1
    )
    expect_no_error({
        cPRZIT_lpx <- lpxt(cPRZ_ITfit, display.exposure = display.exposure)
        cPRZSD_lpx <- lpxt(cPRZ_SDfit, display.exposure = display.exposure)
    })
    
    expect_no_error({
        plot(cPRZIT_lpx)
        plot(cPRZSD_lpx)
        plot(cPRZSD_lpx, plot = "MFx")
        plot(cPRZIT_lpx, plot = "MFx")
    })
})
