% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stationchange.R
\name{resmax}
\alias{resmax}
\title{Maximum residence duration}
\usage{
resmax(
  data,
  ID,
  station,
  res.start,
  residences,
  stnchange,
  drift = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data}{a dataframe of residence events. Residence events must include
tag ID, location name, start time, and duration.}

\item{ID}{a string of the name of the column in \code{data} that holds the tag or
sample IDs.}

\item{station}{a string of the name of the column in \code{data} that holds the
station name or receiver location.}

\item{res.start}{a string of the name of the column in \code{data} that holds the
start date and time. Must be specified and in POSIXt if \code{type="manual"}.}

\item{residences}{a character string with the name of the column in \code{data}
that holds the duration of the residence events.}

\item{stnchange}{a dataframe with the start time and location of the most
recent station or location change. Must use the same column names as \code{data}.}

\item{drift}{indicates if drift residence events should be included in
determining the maximum residence duration}

\item{verbose}{option to display progress bar as function is run. Default
is TRUE.}
}
\value{
a dataframe with the residence information for the longest residence
for each tag ID that occurred before the most recent station/location change.
}
\description{
Find the maximum duration of a single residence in the dataset that occurred
before a station change (i.e., the animal can be assumed to be alive)
}
\examples{
# Identify most recent station change
station.change<-stationchange(data=events,type="mort",ID="ID",
station="Station.Name",verbose=FALSE)

longest_res_events<-resmax(data=events,ID="ID",station="Station.Name",
res.start="ResidenceStart",residences="ResidenceLength.days",
stnchange=station.change,verbose=FALSE)
head(longest_res_events)
}
