% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mo_compbeta}
\alias{mo_compbeta}
\title{Moments of Order Statistics from the Complementary Beta Distribution}
\usage{
mo_compbeta(r, n, k = 1, a, b, rep = 1e+05, seed = 42, verbose = TRUE)
}
\arguments{
\item{r}{rank of the desired order statistic (e.g., \code{1} for the smallest order statistic).}

\item{n}{sample size from which the order statistic is derived.}

\item{k}{order of the moment to compute (default is \code{1}).}

\item{a, b}{positive parameters of the complementary beta distribution.}

\item{rep}{number of simulations (used when \code{b} is non-integer, default is \code{1e5}).}

\item{seed}{optional seed for random number generation to ensure reproducibility (used when \code{b} is non-integer, default is \code{42}).}

\item{verbose}{logical; if \code{TRUE}, prints a message when Monte Carlo simulation is used.}
}
\value{
The estimated or exact \eqn{k}th moment of the \eqn{r}th order statistic from a complementary beta distribution.
}
\description{
This function computes the moments of order statistics from the complementary beta (CB) distribution.
For small values of \code{k} and integer \code{b}, a closed-form formula is used; otherwise,
Monte Carlo simulation is applied.
}
\details{
The computation method varies depending on \code{b} and \code{k}:
\itemize{
  \item \strong{For integer \code{b} and \code{k = 1, 2}}: The function calculates the moments using the closed-form expression derived in Makouei et al. (2021):
  \deqn{\text{E}[X_{r:n}^s] = \frac{1}{B(r, n - r + 1)} \sum_{j=0}^{n-r} \binom{n - r}{j} (-1)^j \mathcal{M}^{(s)}(a, b, r + j - 1),}
  Here
  \deqn{\mathcal{M}^{(s)}(a, b, k) = \frac{1}{k + 1} \left[1 - \frac{s}{B(a, b)} \sum_{j=0}^{\infty} \binom{b-1}{j}
  (-1)^j \mathcal{M}^{(s-1)}(a, b, a + k + j) \right], \quad s \geq 1,}
  with the starting point
  \deqn{\mathcal{M}^{(1)}(a, b, k) = \frac{B(a + k + 1, b + 1)}{a B(a, b)} \cdot
  {_3F_2}\left(a + b, 1, a + k + 1; a + 1, a + b + k + 2; 1\right),}
  where \eqn{B(a, b)} is the beta function, \eqn{_3F_2} is the generalized hypergeometric function,
  and the upper limit of the summation stops at \eqn{j = b - 1} if \code{b} is an integer.

  \item \strong{For non-integer \code{b} or \code{k > 2}}: When \code{b} is non-integer or \code{k} is
  greater than 2 the function employs Monte Carlo simulation using the following formula:
  \deqn{\text{E}[X^s] \approx \frac{1}{\mathrm{rep}} \sum_{i=1}^{\mathrm{rep}} X_i^s,}
  where \eqn{X_i} are the simulated order statistics obtained from the complementary beta distribution.
  The method relies on the \code{ros()} function to generate order statistics.
}

When \code{verbose = TRUE}, the function prints a message only if Monte Carlo simulation is used
(i.e., when \code{k > 2} or \code{b} is non-integer).
}
\note{
The closed-form formula is only available for small values of \code{k} and integer \code{b}.
Monte Carlo simulation is used otherwise, and results may vary slightly depending on \code{rep}.
}
\examples{
# Exact moment when k = 1
mo_compbeta(r = 2, n = 15, k = 1, a = 0.5, b = 2)

# Simulation when k > 2 or b is non-integer
mo_compbeta(r = 2, n = 15, k = 3, a = 2.5, b = 3.7, rep = 1e4)

}
\references{
Makouei, R., Khamnei, H. J., & Salehi, M. (2021). \emph{Moments of order statistics and k-record values arising
from the complementary beta distribution with application.} Journal of Computational and Applied Mathematics,
390, 113386.
}
\seealso{
\link{ros} for generating random samples of order statistics.
}
