% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps_critical_edges.R
\name{plot_gaps_or_critical_dyads}
\alias{plot_gaps_or_critical_dyads}
\title{Helper function for plotting gaps and critical edges}
\usage{
plot_gaps_or_critical_dyads(
  net,
  edge_contribution,
  colour,
  title,
  lvl_attr = c("sesType"),
  cutoff = 2,
  subset_graph = "none",
  ...
)
}
\arguments{
\item{net}{network object}

\item{edge_contribution}{data frame providing edge contribution data}

\item{colour}{colour code for the weighted edges}

\item{title}{title of the plot}

\item{lvl_attr}{nodal attribute specifying level information}

\item{cutoff}{Cut-off point in contributions of an edge to the number of
motifs above which to analyse gaps}

\item{subset_graph}{Whether to subset the graph to only show nodes involved
in gaps. One of "none" (no subset, default), "partial" (only focal level is
subset) or "focal" (only focal level shown)}

\item{...}{list of additional parameters to be passed to plotting function
(see \code{motifr::plot_mnet}), e.g. \code{label = TRUE}}
}
\value{
A plot of gaps or critical edges, sized by weight in a multilevel
  network
}
\description{
Note that this only works for undirected graphs. Regardless of whether the
input graph is directed it is treated as undirected graph.
}
\seealso{
\code{plot_gaps}, \code{plot_critical_dyads}.
}
