% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wavelet.R
\name{plot_wt_energy}
\alias{plot_wt_energy}
\title{Plot wavelet energy of a wavelet object}
\usage{
plot_wt_energy(obj, view)
}
\arguments{
\item{obj}{analyze.wavelet object.}

\item{view}{View object.}
}
\value{
a ggplot object.
}
\description{
Plot wavelet energy of a wavelet object
}
\examples{
r <- get_sample_recording()
rv <- get_raw_view(r, "Central", "", "Sitar")
pv <- get_processed_view(rv)
pv1 <- subset(pv, Time >= 10)
w <- analyze_wavelet(pv1, "Nose_x")
plot_wt_energy(w, pv1)
}
\seealso{
Other wavelet functions: 
\code{\link{analyze_coherency}()},
\code{\link{analyze_wavelet}()},
\code{\link{get_local_max_average_power}()},
\code{\link{plot_average_coherency}()},
\code{\link{plot_average_power}()},
\code{\link{plot_cross_spectrum}()},
\code{\link{plot_cwt_energy}()},
\code{\link{plot_phase_difference}()},
\code{\link{plot_power_spectrum}()},
\code{\link{plot_roll_resultant_length}()},
\code{\link{plot_sel_phases}()}
}
\concept{wavelet functions}
