% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splice.R
\name{sample_time_spliced_views}
\alias{sample_time_spliced_views}
\title{Sample the time line from a list of Views}
\usage{
sample_time_spliced_views(
  ...,
  num_samples,
  replace = FALSE,
  na.action = stats::na.pass
)
}
\arguments{
\item{...}{names arguments of \code{SplicedView} objects.}

\item{num_samples}{number of time points to sample}

\item{replace}{sample with replacement (default is FALSE)?}

\item{na.action}{function to deal with NAs in data (default is na.pass).}
}
\value{
a list of \code{SplitView} object or a \code{SplitView} object
}
\description{
Sample the time line from a list of Views
}
\examples{
r1 <- get_sample_recording()
fv1_list <- get_filtered_views(r1, data_points = "Nose", n = 41, p = 3)
jv1 <- get_joined_view(fv1_list)
l <- list(a=c(1, 2), b = c(2, 3))
splicing_df <- splice_time(l)
sv <- get_spliced_view(jv1, splicing_df = splicing_df)
autoplot(sv)
sv_new <- sample_time_spliced_views(sv, num_samples = 10, replace = FALSE)
autoplot(sv_new)
sv_new <- sample_time_spliced_views(sv, num_samples = 10, replace = TRUE)
autoplot(sv_new)
l <- list(a=c(1, 2), a = c(10, 20), b = c(30, 40))
splicing_df <- splice_time(l)
sv <- get_spliced_view(jv1, splicing_df = splicing_df)
sv_new <- sample_time_spliced_views(sv, num_samples = 20, replace = TRUE)
autoplot(sv_new)
}
