% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpae_package.R
\docType{data}
\name{winequality}
\alias{winequality}
\title{Wine quality data}
\format{
A data frame with 1,250 rows and 12 columns:
\describe{
\item{fixed.acidity}{fixed acidity}
\item{volatile.acidity}{volatile acidity}
\item{citric.acid}{citric acid}
\item{residual.sugar}{residual sugar}
\item{chlorides}{chlorides}
\item{free.sulfur.dioxide}{free sulfur dioxide}
\item{total.sulfur.dioxide}{total sulfur dioxide}
\item{density}{density}
\item{pH}{pH}
\item{sulphates}{sulphates}
\item{alcohol}{alcohol}
\item{quality}{median of at least 3 evaluations of wine quality carried out
by experts, who evaluated them between 0 (very bad) and 10 (very excellent)}
}
}
\source{
UCI Machine Learning Repository: \url{https://archive.ics.uci.edu/dataset/186/wine+quality}.
}
\usage{
winequality
}
\description{
A subset related to the white variant of the Portuguese "Vinho Verde" wine,
containing physicochemical information (\code{fixed.acidity}, \code{volatile.acidity},
\code{citric.acid}, \code{residual.sugar}, \code{chlorides}, \code{free.sulfur.dioxide},
\code{total.sulfur.dioxide} , \code{density}, \code{pH}, \code{sulphates} and \code{alcohol})
and sensory (\code{quality}).
}
\details{
For more details, consult \url{https://www.vinhoverde.pt/en/} or the reference
Cortez et al. (2009).
}
\examples{
str(winequality)
}
\references{
Cortez, P., Cerdeira, A., Almeida, F., Matos, T., & Reis, J. (2009).
Modeling wine preferences by data mining from physicochemical properties.
\emph{Decision Support Systems}, 47(4), 547-553.
}
\seealso{
\code{\link{winetaste}}
}
\keyword{datasets}
